/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Safra
extends AbstractBanco
implements Banco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_SAFRA = "422";
    private static final String DIGITO_NUMERO_SAFRA = "7";
    private static final String COBRANCA_DIRETA_ELETRONICA = "7";
    private static final String TIPO_COBRANCA_EMITIDO_AO_CLIENTE = "2";

    @Override
    public String getNumeroFormatado() {
        return NUMERO_SAFRA;
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder campoLivre = new StringBuilder().append("7");
        campoLivre.append(this.getAgencia(beneficiario));
        campoLivre.append(this.getCodigoBeneficiarioFormatado(beneficiario));
        campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        campoLivre.append(TIPO_COBRANCA_EMITIDO_AO_CLIENTE);
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        StringBuilder builder = new StringBuilder();
        builder.append(StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 8));
        builder.append(beneficiario.getDigitoCodigoBeneficiario());
        return builder.toString();
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 2);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        StringBuilder builder = new StringBuilder();
        builder.append(StellaStringUtils.leftPadWithZeros(beneficiario.getNossoNumero(), 9));
        return builder.toString();
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNumeroFormatado()).append("-");
        return builder.append("7").toString();
    }

    private String getAgencia(Beneficiario beneficiario) {
        StringBuilder builder = new StringBuilder();
        builder.append("0");
        return builder.append(beneficiario.getAgenciaFormatada()).toString();
    }
}

