/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import br.com.caelum.stella.boleto.bancos.gerador.GeradorDeDigitoSantander;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import java.net.URL;

public class Santander
extends AbstractBanco {
    private static final long serialVersionUID = 1L;
    private static final String NUMERO_SANTANDER = "033";
    private static final String DIGITO_SANTANDER = "7";
    private GeradorDeDigitoSantander gdivSantander = new GeradorDeDigitoSantander();

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        StringBuilder campoLivre = new StringBuilder("9");
        campoLivre.append(this.getNumeroConvenioFormatado(beneficiario));
        campoLivre.append(this.getNossoNumeroFormatado(beneficiario));
        campoLivre.append("0").append(beneficiario.getCarteira());
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public URL getImage() {
        String pathDoArquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(pathDoArquivo, NUMERO_SANTANDER);
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_SANTANDER;
    }

    @Override
    public String getCarteiraFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCarteira(), 3);
    }

    @Override
    public String getCodigoBeneficiarioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getCodigoBeneficiario(), 7);
    }

    @Override
    public String getNossoNumeroFormatado(Beneficiario beneficiario) {
        String nossoNumero = beneficiario.getNossoNumero();
        if (beneficiario.getDigitoNossoNumero() != null) {
            return StellaStringUtils.leftPadWithZeros(nossoNumero + beneficiario.getDigitoNossoNumero(), 13);
        }
        return StellaStringUtils.leftPadWithZeros(nossoNumero + this.getGeradorDeDigito().calculaDVNossoNumero(nossoNumero), 13);
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(NUMERO_SANTANDER).append("-");
        return builder.append(DIGITO_SANTANDER).toString();
    }

    @Override
    public String getAgenciaECodigoBeneficiario(Beneficiario beneficiario) {
        StringBuilder builder = new StringBuilder();
        builder.append(StellaStringUtils.leftPadWithZeros(beneficiario.getAgencia(), 5));
        builder.append("/").append(this.getNumeroConvenioFormatado(beneficiario));
        return builder.toString();
    }

    @Override
    public String getNossoNumeroECodigoDocumento(Boleto boleto) {
        Beneficiario beneficiario = boleto.getBeneficiario();
        String nossoNumero = this.getNossoNumeroFormatado(beneficiario);
        StringBuilder builder = new StringBuilder();
        builder.append(nossoNumero.substring(0, 12));
        builder.append("-").append(nossoNumero.substring(12));
        return builder.toString();
    }

    @Override
    public GeradorDeDigitoSantander getGeradorDeDigito() {
        return this.gdivSantander;
    }

    public String getNumeroConvenioFormatado(Beneficiario beneficiario) {
        return StellaStringUtils.leftPadWithZeros(beneficiario.getNumeroConvenio(), 7);
    }
}

