/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos.gerador;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.boleto.bancos.gerador.GeradorDeDigitoPadrao;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;

public class GeradorDeDigitoSantander
extends GeradorDeDigitoPadrao {
    private static final long serialVersionUID = 1L;

    @Override
    public int geraDigitoBloco1(String bloco) {
        return this.calculaDVBloco(bloco);
    }

    @Override
    public int geraDigitoBloco2(String bloco) {
        return this.calculaDVBloco(bloco);
    }

    @Override
    public int geraDigitoBloco3(String bloco) {
        return this.calculaDVBloco(bloco);
    }

    public int calculaDVBloco(String bloco) {
        int soma = 0;
        int i = bloco.length() - 1;
        int multiplicador = 2;
        while (i >= 0) {
            int parcial;
            if (multiplicador == 0) {
                multiplicador = 2;
            }
            if ((parcial = Integer.parseInt(String.valueOf(bloco.charAt(i))) * multiplicador) > 9) {
                parcial -= 9;
            }
            soma += parcial;
            --i;
            --multiplicador;
        }
        int resto = soma % 10;
        if (resto == 0) {
            return 0;
        }
        return 10 - resto;
    }

    public String calculaDVNossoNumero(String nossoNumero) {
        if (nossoNumero == null || nossoNumero.length() > 12) {
            throw new IllegalArgumentException("Nosso N\u00famero inv\u00e1lido: " + nossoNumero);
        }
        DigitoPara digitoPara = new DigitoPara(StellaStringUtils.leftPadWithZeros(nossoNumero, 12));
        int digito = Integer.parseInt(digitoPara.comMultiplicadoresDeAte(2, 9).mod(11).trocandoPorSeEncontrar("0", new Integer[]{1}).trocandoPorSeEncontrar("1", new Integer[]{10}).calcula());
        if (digito > 1) {
            digito = 11 - digito;
        }
        return String.valueOf(digito);
    }
}

