/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;

public class GeradorDeBoleto {
    protected final Collection<Boleto> boletos;
    protected InputStream templateJasper;
    protected JasperPrint relatorio;
    protected Map<String, Object> parametros = new HashMap<String, Object>();

    public GeradorDeBoleto(Collection<Boleto> boletos) {
        this.boletos = boletos;
        try {
            this.templateJasper = GeradorDeBoleto.class.getResourceAsStream("/br/com/caelum/stella/boleto/templates/boleto-default.jasper");
            this.parametros.put("REPORT_LOCALE", new Locale("pt", "BR"));
            InputStream template_sub = GeradorDeBoleto.class.getResourceAsStream("/br/com/caelum/stella/boleto/templates/boleto-default_instrucoes.jasper");
            this.parametros.put("SUB_INSTRUCOES", JRLoader.loadObject((InputStream)template_sub));
        }
        catch (JRException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
    }

    public GeradorDeBoleto(Boleto ... boletos) {
        this(Arrays.asList(boletos));
    }

    public GeradorDeBoleto(InputStream template, Map<String, Object> parametros, Boleto ... boletos) {
        this(boletos);
        this.templateJasper = template;
        if (parametros != null) {
            Set<Map.Entry<String, Object>> entrySet = parametros.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                this.parametros.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public GeradorDeBoleto(InputStream template, Map<String, Object> parametros, Collection<Boleto> boletos) {
        this(boletos);
        this.templateJasper = template;
        if (parametros != null) {
            Set<Map.Entry<String, Object>> entrySet = parametros.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                this.parametros.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void geraPDF(String arquivo) {
        this.geraPDF(new File(arquivo));
    }

    protected JasperPrint geraRelatorio() {
        try {
            if (this.relatorio == null) {
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(this.boletos);
                this.relatorio = JasperFillManager.fillReport((InputStream)this.templateJasper, this.parametros, (JRDataSource)dataSource);
            }
            return this.relatorio;
        }
        catch (Exception e) {
            throw new GeracaoBoletoException(e);
        }
    }

    public void geraPDF(File arquivo) {
        try {
            FileOutputStream out = new FileOutputStream(arquivo);
            this.geraPDF(out);
        }
        catch (FileNotFoundException e) {
            throw new GeracaoBoletoException(e);
        }
    }

    public void geraPDF(OutputStream out) {
        try {
            JasperPrint relatorio = this.geraRelatorio();
            JasperExportManager.exportReportToPdfStream((JasperPrint)relatorio, (OutputStream)out);
        }
        catch (Exception e) {
            throw new GeracaoBoletoException(e);
        }
    }

    public void geraPNG(String arquivo) {
        this.geraPNG(new File(arquivo));
    }

    public void geraPNG(File arquivo) {
        try {
            this.geraPNG(new FileOutputStream(arquivo));
        }
        catch (FileNotFoundException e) {
            throw new GeracaoBoletoException(e);
        }
    }

    public void geraPNG(OutputStream out) {
        try {
            JasperPrint relatorio = this.geraRelatorio();
            BufferedImage image = (BufferedImage)JasperPrintManager.printPageToImage((JasperPrint)relatorio, (int)0, (float)2.0f);
            ImageIO.write((RenderedImage)image, "png", out);
        }
        catch (Exception e) {
            throw new GeracaoBoletoException(e);
        }
    }

    public byte[] geraPDF() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.geraPDF(stream);
        return stream.toByteArray();
    }

    public byte[] geraPNG() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.geraPNG(stream);
        return stream.toByteArray();
    }

    public InputStream geraPDFStream() {
        return new ByteArrayInputStream(this.geraPDF());
    }

    public InputStream geraPNGStream() {
        return new ByteArrayInputStream(this.geraPNG());
    }
}

