/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.GeradorDeBoleto;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;

public class GeradorDeBoletoHTML
extends GeradorDeBoleto {
    private JRHtmlExporter exporter = new JRHtmlExporter();

    public GeradorDeBoletoHTML(Boleto ... boletos) {
        super(boletos);
        this.exporter.setParameter(JRHtmlExporterParameter.CHARACTER_ENCODING, (Object)"ISO-8859-1");
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.ZOOM_RATIO, (Object)Float.valueOf(1.3f));
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"stella-boleto?image=");
        this.exporter.setParameter(JRHtmlExporterParameter.CHARACTER_ENCODING, (Object)"ISO-8859-1");
    }

    public GeradorDeBoletoHTML(InputStream template, Map<String, Object> parametros, Boleto ... boletos) {
        super(template, parametros, boletos);
        this.exporter.setParameter(JRHtmlExporterParameter.CHARACTER_ENCODING, (Object)"ISO-8859-1");
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.ZOOM_RATIO, (Object)Float.valueOf(1.3f));
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"stella-boleto?image=");
        this.exporter.setParameter(JRHtmlExporterParameter.CHARACTER_ENCODING, (Object)"ISO-8859-1");
    }

    public void setJasperParameter(JRExporterParameter parameter, Object value) {
        this.exporter.setParameter(parameter, value);
    }

    public void geraHTML(String arquivo) {
        try {
            JasperExportManager.exportReportToHtmlFile((JasperPrint)this.geraRelatorio(), (String)arquivo);
        }
        catch (JRException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
    }

    public void geraHTML(File arquivo) {
        this.geraHTML(arquivo.getAbsolutePath());
    }

    public void geraHTML(Writer writer, HttpServletRequest request) {
        try {
            JRHtmlExporter exporter = this.getHtmlExporter(request);
            exporter.setParameter(JRHtmlExporterParameter.OUTPUT_WRITER, (Object)writer);
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
    }

    protected JRHtmlExporter getHtmlExporter(HttpServletRequest request) {
        JasperPrint relatorio = this.geraRelatorio();
        this.exporter.setParameter(JRHtmlExporterParameter.JASPER_PRINT, (Object)relatorio);
        request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)relatorio);
        return this.exporter;
    }
}

