/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.amazonS3;

import br.com.caelum.vraptor.environment.Environment;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@ApplicationScoped
public class AmazonS3ClientFactory {
    private final Environment env;
    private AmazonS3Client amazonS3Client;
    public static final String CREDENTIALS_PROPERTY = "br.com.caelum.vraptor.amazonS3.credentials";

    @Deprecated
    AmazonS3ClientFactory() {
        this(null);
    }

    @Inject
    public AmazonS3ClientFactory(Environment env) {
        this.env = env;
    }

    @Produces
    public AmazonS3Client getInstance() {
        return this.amazonS3Client;
    }

    @PostConstruct
    public void create() {
        URL resource = this.getCredentialsResource();
        try {
            PropertiesCredentials credentials = new PropertiesCredentials(new File(resource.getFile()));
            this.amazonS3Client = new AmazonS3Client((AWSCredentials)credentials);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Could not instantiate amazon S3 client", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate amazon S3 client", e);
        }
    }

    private URL getCredentialsResource() {
        String propertiesFile = "";
        propertiesFile = this.env.get(CREDENTIALS_PROPERTY, "/AwsCredentials.properties");
        URL resource = this.env.getResource(propertiesFile);
        if (resource == null) {
            throw new IllegalStateException("Could not found your credentials resource, please place it at a source folder with name AwsCredentials.properties or set its path with br.com.caelum.vraptor.amazonS3.credentials in your environment file.");
        }
        return resource;
    }
}

