/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.amazonS3;

import br.com.caelum.vraptor.amazonS3.AmazonS3ClientFactory;
import br.com.caelum.vraptor.amazonS3.FileStorage;
import br.com.caelum.vraptor.amazonS3.LocalFileStorage;
import br.com.caelum.vraptor.amazonS3.S3FileStorage;
import br.com.caelum.vraptor.environment.Environment;
import com.amazonaws.services.s3.AmazonS3Client;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.ServletContext;

@ApplicationScoped
public class FileStorageFactory {
    private static final String BUCKET_KEY = "br.com.caelum.vraptor.amazons3.bucket";
    private final Environment env;
    private FileStorage fileStorage;
    private ServletContext context;

    @Deprecated
    FileStorageFactory() {
        this(null, null);
    }

    @Inject
    public FileStorageFactory(Environment env, ServletContext context) {
        this.env = env;
        this.context = context;
    }

    @PostConstruct
    public void init() {
        String credentialsFile = this.env.get("br.com.caelum.vraptor.amazonS3.credentials", "/AwsCredentials.properties");
        URL credentials = this.env.getResource(credentialsFile);
        if (credentials == null) {
            this.fileStorage = new LocalFileStorage(this.env, this.context);
        } else {
            AmazonS3ClientFactory factory = new AmazonS3ClientFactory(this.env);
            factory.create();
            AmazonS3Client client = factory.getInstance();
            String bucket = this.env.get(BUCKET_KEY);
            this.fileStorage = new S3FileStorage(client, bucket);
        }
    }

    @Produces
    public FileStorage getFileStorage() {
        return this.fileStorage;
    }
}

