/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.amazonS3;

import br.com.caelum.vraptor.amazonS3.FileStorage;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class S3FileStorage
implements FileStorage {
    private final AmazonS3Client amazonS3Client;
    private String bucket;

    public S3FileStorage(AmazonS3Client amazonS3Client, String bucket) {
        this.amazonS3Client = amazonS3Client;
        this.bucket = bucket;
    }

    @Override
    public URL store(File file, String key) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, file).withCannedAcl(CannedAccessControlList.PublicRead);
        this.amazonS3Client.putObject(putObjectRequest);
        return this.urlFor(this.bucket, key);
    }

    @Override
    public URL store(InputStream is, String path, String contentType) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(contentType);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, path, is, metadata).withCannedAcl(CannedAccessControlList.PublicRead);
        this.amazonS3Client.putObject(putObjectRequest);
        return this.urlFor(this.bucket, path);
    }

    @Override
    public void newBucket(String bucket) {
        this.amazonS3Client.createBucket(bucket);
    }

    @Override
    public URL urlFor(String bucket, String key) {
        try {
            return new URL("http://" + bucket + ".s3.amazonaws.com/" + key);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

