/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.proxy;

import br.gov.frameworkdemoiselle.internal.proxy.EntityManagerProxy;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;

public class TypedQueryProxy<X>
implements TypedQuery<X> {
    private TypedQuery<X> queryDelegate;
    private EntityManagerProxy entityManagerCaller;

    public TypedQueryProxy(TypedQuery<X> queryDelegate, EntityManagerProxy entityManagerCaller) {
        this.queryDelegate = queryDelegate;
        this.entityManagerCaller = entityManagerCaller;
    }

    public List<X> getResultList() {
        this.entityManagerCaller.joinTransactionIfNecessary();
        return this.queryDelegate.getResultList();
    }

    public X getSingleResult() {
        this.entityManagerCaller.joinTransactionIfNecessary();
        return (X)this.queryDelegate.getSingleResult();
    }

    public int executeUpdate() {
        this.entityManagerCaller.joinTransactionIfNecessary();
        return this.queryDelegate.executeUpdate();
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        this.queryDelegate.setMaxResults(maxResult);
        return this;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        this.queryDelegate.setFirstResult(startPosition);
        return this;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        this.queryDelegate.setHint(hintName, value);
        return this;
    }

    public int getMaxResults() {
        return this.queryDelegate.getMaxResults();
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        this.queryDelegate.setParameter(param, value);
        return this;
    }

    public int getFirstResult() {
        return this.queryDelegate.getFirstResult();
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.queryDelegate.setParameter(param, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.queryDelegate.setParameter(param, value, temporalType);
        return this;
    }

    public Map<String, Object> getHints() {
        return this.queryDelegate.getHints();
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        this.queryDelegate.setParameter(name, value);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        this.queryDelegate.setParameter(name, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        this.queryDelegate.setParameter(name, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        this.queryDelegate.setParameter(position, value);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        this.queryDelegate.setParameter(position, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        this.queryDelegate.setParameter(position, value, temporalType);
        return this;
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushMode) {
        this.queryDelegate.setFlushMode(flushMode);
        return this;
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.queryDelegate.setLockMode(lockMode);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        return this.queryDelegate.getParameters();
    }

    public Parameter<?> getParameter(String name) {
        return this.queryDelegate.getParameter(name);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.queryDelegate.getParameter(name, type);
    }

    public Parameter<?> getParameter(int position) {
        return this.queryDelegate.getParameter(position);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this.queryDelegate.getParameter(position, type);
    }

    public boolean isBound(Parameter<?> param) {
        return this.queryDelegate.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.queryDelegate.getParameterValue(param);
    }

    public Object getParameterValue(String name) {
        return this.queryDelegate.getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        return this.queryDelegate.getParameterValue(position);
    }

    public FlushModeType getFlushMode() {
        return this.queryDelegate.getFlushMode();
    }

    public LockModeType getLockMode() {
        return this.queryDelegate.getLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.queryDelegate.unwrap(cls);
    }
}

