/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.configuration.RESTConfig;
import br.gov.frameworkdemoiselle.transaction.BeforeTransactionComplete;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@WebListener
public class SessionNotAllowedListener
implements ServletContextListener,
HttpSessionListener {
    private static final String ATTR_NAME = "br.gov.frameworkdemoiselle.SESSION_NOT_ALLOWED";
    private static final String ATTR_VALUE = "created";
    private transient RESTConfig config;
    private transient ResourceBundle bundle;

    public void contextInitialized(ServletContextEvent event) {
        if (!this.getConfig().isSessionAllowed()) {
            HashSet<SessionTrackingMode> modes = new HashSet<SessionTrackingMode>();
            modes.add(SessionTrackingMode.URL);
            event.getServletContext().setSessionTrackingModes(modes);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.getConfig().isSessionAllowed()) {
            ((HttpServletRequest)Beans.getReference(HttpServletRequest.class)).setAttribute(ATTR_NAME, (Object)ATTR_VALUE);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void beforeTransactionComplete(@Observes BeforeTransactionComplete event, HttpServletRequest request) {
        if (!this.getConfig().isSessionAllowed() && request != null && ATTR_VALUE.equals(request.getAttribute(ATTR_NAME))) {
            this.invalidateSesstion(request);
            throw new IllegalStateException(this.getBundle().getString("session-not-allowed"));
        }
    }

    private void invalidateSesstion(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    private RESTConfig getConfig() {
        if (this.config == null) {
            this.config = (RESTConfig)Beans.getReference(RESTConfig.class);
        }
        return this.config;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-rest-bundle")});
        }
        return this.bundle;
    }
}

