/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.security.Authenticator;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.ServletAuthenticator;
import br.gov.frameworkdemoiselle.security.Token;
import br.gov.frameworkdemoiselle.security.TokenManager;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.StrategyQualifier;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.enterprise.context.RequestScoped;

@RequestScoped
@Priority(value=0x7FFFFF37)
public class TokenAuthenticator
implements Authenticator {
    private static final long serialVersionUID = 1L;
    private Principal user;

    public void authenticate() throws Exception {
        Token token = (Token)Beans.getReference(Token.class);
        TokenManager tokenManager = (TokenManager)Beans.getReference(TokenManager.class, (Annotation[])new Annotation[]{new StrategyQualifier()});
        if (token.isEmpty()) {
            this.user = this.customAuthentication();
            String newToken = tokenManager.persist(this.user);
            token.setValue(newToken);
        } else {
            this.user = this.tokenAuthentication(token, tokenManager);
        }
    }

    protected Principal customAuthentication() throws Exception {
        ServletAuthenticator authenticator = (ServletAuthenticator)Beans.getReference(ServletAuthenticator.class);
        authenticator.authenticate();
        return authenticator.getUser();
    }

    private Principal tokenAuthentication(Token token, TokenManager tokenManager) throws Exception {
        Principal principal = tokenManager.load(token.getValue());
        if (principal == null) {
            throw new InvalidCredentialsException("token inv\u00e1lido");
        }
        return principal;
    }

    public void unauthenticate() {
        this.user = null;
    }

    public Principal getUser() {
        return this.user;
    }
}

