/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.BackendPayload;
import ca.derekcormier.recipe.BaseIngredientHook;
import ca.derekcormier.recipe.Cake;
import ca.derekcormier.recipe.IngredientSnapshot;
import ca.derekcormier.recipe.RecipeSnapshot;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import java.util.HashMap;
import java.util.Map;

public class BackendOven {
    private final Map<String, BaseIngredientHook> hooks = new HashMap<String, BaseIngredientHook>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SubtypeResolver subtypeResolver = new StdSubtypeResolver();

    public BackendOven() {
        this.objectMapper.setSubtypeResolver(this.subtypeResolver);
        this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(RecipeSnapshot.class, "Recipe")});
    }

    public String bake(String json) {
        try {
            BackendPayload payload = (BackendPayload)this.objectMapper.readValue(json, BackendPayload.class);
            Cake cake = payload.getCake();
            this.bakeIngredient(payload.getRecipe(), cake);
            return this.objectMapper.writeValueAsString((Object)cake);
        }
        catch (Exception e) {
            throw new RuntimeException("payload serialization error", e);
        }
    }

    public void registerHook(BaseIngredientHook hook) {
        this.hooks.put(hook.getIngredientName(), hook);
        this.subtypeResolver.registerSubtypes(new NamedType[]{new NamedType(hook.getDataClass(), hook.getIngredientName())});
    }

    private void bakeIngredient(IngredientSnapshot ingredient, Cake cake) {
        if (ingredient instanceof RecipeSnapshot) {
            RecipeSnapshot recipe = (RecipeSnapshot)ingredient;
            Runnable bakeRecipeIngredients = () -> {
                for (IngredientSnapshot i : recipe.getIngredients()) {
                    this.bakeIngredient(i, cake);
                }
            };
            if (recipe.getContext() != null) {
                cake.inNamespace(recipe.getContext(), bakeRecipeIngredients);
            } else if (recipe.getContextIngredient() != null) {
                this.bakeIngredient(recipe.getContextIngredient(), cake);
                if (recipe.getContextIngredient().getKey() != null) {
                    cake.inNamespace(recipe.getContextIngredient().getKey(), bakeRecipeIngredients);
                } else {
                    bakeRecipeIngredients.run();
                }
            } else {
                bakeRecipeIngredients.run();
            }
        } else {
            this.hooks.get(ingredient.getIngredientType()).bake(ingredient, cake);
        }
    }
}

