/*
 * Decompiled with CFR 0.152.
 */
package ca.derekcormier.recipe;

import ca.derekcormier.recipe.Ingredient;
import ca.derekcormier.recipe.KeyedIngredient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Recipe
extends Ingredient {
    @JsonProperty(value="context")
    private String context;
    @JsonProperty(value="contextIngredient")
    private KeyedIngredient contextIngredient;
    @JsonProperty(value="ingredients")
    private final List<Ingredient> ingredients;

    public static Recipe prepare(Ingredient ... ingredients) {
        return new Recipe(ingredients);
    }

    public static Recipe context(String context, Ingredient ... ingredients) {
        Recipe recipe = new Recipe(ingredients);
        recipe.context = context;
        return recipe;
    }

    public static Recipe context(KeyedIngredient context, Ingredient ... ingredients) {
        Recipe recipe = new Recipe(ingredients);
        recipe.contextIngredient = context;
        return recipe;
    }

    protected Recipe() {
        super("Recipe");
        this.ingredients = new ArrayList<Ingredient>();
    }

    protected Recipe(Ingredient ... ingredients) {
        super("Recipe");
        this.ingredients = Arrays.asList(ingredients);
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public String getContext() {
        return this.context;
    }

    public KeyedIngredient getContextIngredient() {
        return this.contextIngredient;
    }

    protected List<Segment> segment() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Recipe> recipeStack = new ArrayList<Recipe>();
        recipeStack.add(this);
        this._segment(new Recipe(), recipeStack, null, segments);
        return segments;
    }

    private void _segment(Recipe currRecipe, List<Recipe> recipeStack, String currDomain, List<Segment> segments) {
        Recipe recipe;
        if (recipeStack.get((int)0).contextIngredient != null) {
            KeyedIngredient contextIngredient = recipeStack.get((int)0).contextIngredient;
            if (!contextIngredient.getDomain().equals(currDomain)) {
                Recipe outerRecipe = null;
                recipe = null;
                for (Recipe recipe2 : recipeStack) {
                    if (recipe == null) {
                        recipe = outerRecipe = new Recipe();
                    } else {
                        outerRecipe = Recipe.prepare(outerRecipe);
                    }
                    outerRecipe.context = recipe2.context;
                    outerRecipe.contextIngredient = recipe2.contextIngredient;
                }
                Segment segmented = new Segment();
                segmented.domain = contextIngredient.getDomain();
                segmented.recipe = outerRecipe;
                segments.add(segmented);
                currRecipe = recipe;
                currDomain = contextIngredient.getDomain();
            }
            currRecipe.contextIngredient = contextIngredient;
        }
        for (Ingredient ingredient : recipeStack.get((int)0).ingredients) {
            if (ingredient instanceof Recipe) {
                recipe = new Recipe();
                recipe.contextIngredient = ((Recipe)ingredient).contextIngredient;
                recipe.context = ((Recipe)ingredient).context;
                recipeStack.add(0, (Recipe)ingredient);
                this._segment(recipe, recipeStack, currDomain, segments);
                if (recipe.ingredients.isEmpty()) continue;
                currRecipe.ingredients.add(recipe);
                continue;
            }
            if (!ingredient.getDomain().equals(currDomain)) {
                Recipe outerRecipe = null;
                Recipe recipe2 = null;
                for (Recipe r : recipeStack) {
                    if (recipe2 == null) {
                        recipe2 = outerRecipe = new Recipe();
                    } else {
                        outerRecipe = Recipe.prepare(outerRecipe);
                    }
                    outerRecipe.context = r.context;
                    outerRecipe.contextIngredient = r.contextIngredient;
                }
                Segment segment = new Segment();
                segment.domain = ingredient.getDomain();
                segment.recipe = outerRecipe;
                segments.add(segment);
                currRecipe = recipe2;
                currDomain = ingredient.getDomain();
            }
            currRecipe.ingredients.add(ingredient);
        }
        recipeStack.remove(0);
    }

    public class Segment {
        public String domain;
        public Recipe recipe;
    }
}

