/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2;

import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.jpa.api.svc.IGoldenResourceSearchSvc;
import ca.uhn.fhir.mdm.batch2.MdmChunkRangeJson;
import jakarta.annotation.Nullable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmIdChunkProducer
implements IIdChunkProducer<MdmChunkRangeJson> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmIdChunkProducer.class);
    private final IGoldenResourceSearchSvc myGoldenResourceSearchSvc;

    public MdmIdChunkProducer(IGoldenResourceSearchSvc theGoldenResourceSearchSvc) {
        this.myGoldenResourceSearchSvc = theGoldenResourceSearchSvc;
    }

    public IResourcePidStream fetchResourceIdStream(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, MdmChunkRangeJson theData) {
        String resourceType = theData.getResourceType();
        ourLog.info("Fetching golden resource ID chunk for resource type {} - Range {} - {}", new Object[]{resourceType, theStart, theEnd});
        return this.myGoldenResourceSearchSvc.fetchGoldenResourceIdStream(theStart, theEnd, theRequestPartitionId, resourceType);
    }
}

