/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.clear;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MdmClearJobParametersValidator
implements IJobParametersValidator<MdmClearJobParameters> {
    private final DaoRegistry myDaoRegistry;
    private final IMdmSettings myMdmSettings;

    public MdmClearJobParametersValidator(DaoRegistry theDaoRegistry, IMdmSettings theMdmSettings) {
        this.myDaoRegistry = theDaoRegistry;
        this.myMdmSettings = theMdmSettings;
    }

    @Nullable
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull MdmClearJobParameters theParameters) {
        if (this.myMdmSettings == null || !this.myMdmSettings.isEnabled()) {
            return Collections.singletonList("Mdm is not enabled on this server");
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (theParameters.getResourceNames() == null || theParameters.getResourceNames().isEmpty()) {
            retval.add("Mdm Clear Job Parameters must define at least one resource type");
        } else {
            for (String resourceType : theParameters.getResourceNames()) {
                if (!this.myDaoRegistry.isResourceTypeSupported(resourceType)) {
                    retval.add("Resource type '" + resourceType + "' is not supported on this server.");
                }
                if (this.myMdmSettings.getMdmRules().getMdmTypes().contains(resourceType)) continue;
                retval.add("There are no mdm rules for resource type '" + resourceType + "'");
            }
        }
        return retval;
    }
}

