/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.submit;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.jobs.chunk.PartitionedUrlChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.step.GenerateRangeChunksStep;
import ca.uhn.fhir.batch2.jobs.step.LoadIdsStep;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.batch2.submit.MdmInflateAndSubmitResourcesStep;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParameters;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParametersValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MdmSubmitAppCtx {
    public static final String MDM_SUBMIT_JOB_BEAN_NAME = "mdmSubmitJobDefinition";
    public static String MDM_SUBMIT_JOB = "MDM_SUBMIT";

    @Bean
    public GenerateRangeChunksStep submitGenerateRangeChunksStep() {
        return new GenerateRangeChunksStep();
    }

    @Bean(name={"mdmSubmitJobDefinition"})
    public JobDefinition mdmSubmitJobDefinition(IBatch2DaoSvc theBatch2DaoSvc, MatchUrlService theMatchUrlService, FhirContext theFhirContext, IMdmSettings theMdmSettings) {
        return JobDefinition.newBuilder().setJobDefinitionId(MDM_SUBMIT_JOB).setJobDescription("MDM Batch Submission").setJobDefinitionVersion(1).setParametersType(MdmSubmitJobParameters.class).setParametersValidator((IJobParametersValidator)this.mdmSubmitJobParametersValidator(theMatchUrlService, theFhirContext, theMdmSettings)).addFirstStep("generate-ranges", "generate data ranges to submit to mdm", PartitionedUrlChunkRangeJson.class, (IJobStepWorker)this.submitGenerateRangeChunksStep()).addIntermediateStep("load-ids", "Load the IDs", ResourceIdListWorkChunkJson.class, (IJobStepWorker)new LoadIdsStep(theBatch2DaoSvc)).addLastStep("inflate-and-submit-resources", "Inflate and Submit resources", (IJobStepWorker)this.mdmInflateAndSubmitResourcesStep()).build();
    }

    @Bean
    public MdmSubmitJobParametersValidator mdmSubmitJobParametersValidator(MatchUrlService theMatchUrlService, FhirContext theFhirContext, IMdmSettings theMdmSettings) {
        return new MdmSubmitJobParametersValidator(theMdmSettings, theMatchUrlService, theFhirContext);
    }

    @Bean
    public MdmInflateAndSubmitResourcesStep mdmInflateAndSubmitResourcesStep() {
        return new MdmInflateAndSubmitResourcesStep();
    }
}

