/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.submit;

import ca.uhn.fhir.batch2.api.IJobParametersValidator;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.batch2.submit.MdmSubmitJobParameters;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public class MdmSubmitJobParametersValidator
implements IJobParametersValidator<MdmSubmitJobParameters> {
    private IMdmSettings myMdmSettings;
    private MatchUrlService myMatchUrlService;
    private FhirContext myFhirContext;

    public MdmSubmitJobParametersValidator(IMdmSettings theMdmSettings, MatchUrlService theMatchUrlService, FhirContext theFhirContext) {
        this.myMdmSettings = theMdmSettings;
        this.myMatchUrlService = theMatchUrlService;
        this.myFhirContext = theFhirContext;
    }

    @Nonnull
    public List<String> validate(RequestDetails theRequestDetails, @Nonnull MdmSubmitJobParameters theParameters) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (PartitionedUrl partitionedUrl : theParameters.getPartitionedUrls()) {
            String url = partitionedUrl.getUrl();
            String resourceType = this.getResourceTypeFromUrl(url);
            RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(resourceType);
            this.validateTypeIsUsedByMdm(errorMsgs, resourceType);
            this.validateAllSearchParametersApplyToResourceType(errorMsgs, partitionedUrl, resourceType, resourceDefinition);
        }
        return errorMsgs;
    }

    private void validateAllSearchParametersApplyToResourceType(List<String> errorMsgs, PartitionedUrl partitionedUrl, String resourceType, RuntimeResourceDefinition resourceDefinition) {
        try {
            this.myMatchUrlService.translateMatchUrl(partitionedUrl.getUrl(), resourceDefinition, new MatchUrlService.Flag[0]);
        }
        catch (MatchUrlService.UnrecognizedSearchParameterException e) {
            String errorMsg = String.format("Search parameter %s is not recognized for resource type %s. Source error is %s", e.getParamName(), resourceType, e.getMessage());
            errorMsgs.add(errorMsg);
        }
        catch (InvalidRequestException e) {
            errorMsgs.add("Invalid request detected: " + e.getMessage());
        }
    }

    private void validateTypeIsUsedByMdm(List<String> errorMsgs, String resourceType) {
        if (!this.myMdmSettings.isSupportedMdmType(resourceType)) {
            errorMsgs.add("Resource type " + resourceType + " is not supported by MDM. Check your MDM settings");
        }
    }

    private String getResourceTypeFromUrl(String url) {
        int questionMarkIndex = url.indexOf(63);
        String resourceType = questionMarkIndex == -1 ? url : url.substring(0, questionMarkIndex);
        return resourceType;
    }
}

