/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.elementmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.conformance.ProfileUtilities;
import org.hl7.fhir.r4b.context.IWorkerContext;
import org.hl7.fhir.r4b.elementmodel.Element;
import org.hl7.fhir.r4b.elementmodel.ParserBase;
import org.hl7.fhir.r4b.elementmodel.Property;
import org.hl7.fhir.r4b.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r4b.formats.IParser;
import org.hl7.fhir.r4b.formats.JsonCreator;
import org.hl7.fhir.r4b.formats.JsonCreatorCanonical;
import org.hl7.fhir.r4b.formats.JsonCreatorGson;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class JsonParser
extends ParserBase {
    private JsonCreator json;
    private Map<JsonElement, JsonTrackingParser.LocationData> map;
    private boolean allowComments;
    private ProfileUtilities profileUtilities;

    public JsonParser(IWorkerContext context, ProfileUtilities utilities) {
        super(context);
        this.profileUtilities = utilities;
    }

    public JsonParser(IWorkerContext context) {
        super(context);
        this.profileUtilities = new ProfileUtilities(this.context, null, null, new FHIRPathEngine(context));
    }

    public Element parse(String source, String type) throws Exception {
        JsonObject obj = (JsonObject)new com.google.gson.JsonParser().parse(source);
        String path = "/" + type;
        StructureDefinition sd = this.getDefinition(-1, -1, type);
        if (sd == null) {
            return null;
        }
        Element result = new Element(type, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities));
        result.setPath(type);
        this.checkObject(obj, path);
        result.setType(type);
        this.parseChildren(path, obj, result, true);
        result.numberChildren();
        return result;
    }

    @Override
    public List<ParserBase.NamedElement> parse(InputStream stream) throws IOException, FHIRException {
        ArrayList<ParserBase.NamedElement> res = new ArrayList<ParserBase.NamedElement>();
        this.map = new IdentityHashMap<JsonElement, JsonTrackingParser.LocationData>();
        String source = TextFile.streamToString((InputStream)stream);
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            JsonObject obj = null;
            try {
                obj = JsonTrackingParser.parse((String)source, this.map, (boolean)false, (boolean)this.allowComments);
            }
            catch (Exception e) {
                this.logError(-1, -1, this.context.formatMessage("documentmsg", new Object[0]), ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_", e.getMessage()), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            assert (this.map.containsKey(obj));
            Element e = this.parse(obj);
            if (e != null) {
                res.add(new ParserBase.NamedElement(this, null, e));
            }
        } else {
            JsonObject obj = JsonTrackingParser.parse((String)source, null);
            Element e = this.parse(obj);
            if (e != null) {
                res.add(new ParserBase.NamedElement(this, null, e));
            }
        }
        return res;
    }

    public Element parse(JsonObject object, Map<JsonElement, JsonTrackingParser.LocationData> map) throws FHIRException {
        this.map = map;
        return this.parse(object);
    }

    public Element parse(JsonObject object) throws FHIRException {
        String name;
        JsonElement rt = object.get("resourceType");
        if (rt == null) {
            this.logError(this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        String path = name = rt.getAsString();
        StructureDefinition sd = this.getDefinition(this.line((JsonElement)object), this.col((JsonElement)object), name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities));
        this.checkObject(object, path);
        result.markLocation(this.line((JsonElement)object), this.col((JsonElement)object));
        result.setType(name);
        result.setPath(result.fhirType());
        this.parseChildren(path, object, result, true);
        result.numberChildren();
        return result;
    }

    private void checkObject(JsonObject object, String path) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            boolean found = false;
            Iterator iterator = object.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry e = (Map.Entry)iterator.next();
                found = true;
            }
            if (!found) {
                this.logError(this.line((JsonElement)object), this.col((JsonElement)object), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Object_must_have_some_content", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private void parseChildren(String path, JsonObject object, Element element, boolean hasResourceType) throws FHIRException {
        this.reapComments(object, element);
        List<Property> properties = element.getProperty().getChildProperties(element.getName(), null);
        HashSet<String> processed = new HashSet<String>();
        if (hasResourceType) {
            processed.add("resourceType");
        }
        for (Property property : properties) {
            this.parseChildItem(path, object, element, processed, property);
        }
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (Map.Entry e : object.entrySet()) {
                if (processed.contains(e.getKey())) continue;
                this.logError(this.line((JsonElement)e.getValue()), this.col((JsonElement)e.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Unrecognised_property_", e.getKey()), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    public void parseChildItem(String path, JsonObject object, Element context, Set<String> processed, Property property) {
        if (property.isChoice() || property.getDefinition().getPath().endsWith("data[x]")) {
            for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                String eName = property.getName().substring(0, property.getName().length() - 3) + Utilities.capitalize((String)type.getWorkingCode());
                if (!this.isPrimitive(type.getWorkingCode()) && object.has(eName)) {
                    this.parseChildComplex(path, object, context, processed, property, eName);
                } else {
                    if (!this.isPrimitive(type.getWorkingCode()) || !object.has(eName) && !object.has("_" + eName)) continue;
                    this.parseChildPrimitive(object, context, processed, property, path, eName);
                }
                break;
            }
        } else if (property.isPrimitive(property.getType(null))) {
            this.parseChildPrimitive(object, context, processed, property, path, property.getName());
        } else if (object.has(property.getName())) {
            this.parseChildComplex(path, object, context, processed, property, property.getName());
        }
    }

    private void parseChildComplex(String path, JsonObject object, Element element, Set<String> processed, Property property, String name) throws FHIRException {
        processed.add(name);
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        JsonElement e = object.get(name);
        if (property.isList() && e instanceof JsonArray) {
            JsonArray arr = (JsonArray)e;
            if (arr.size() == 0) {
                this.logError(this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("ARRAY_CANNOT_BE_EMPTY", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            int c = 0;
            for (JsonElement am : arr) {
                this.parseChildComplexInstance(npath + "[" + c + "]", fpath + "[" + c + "]", object, element, property, name, am);
                ++c;
            }
        } else {
            if (property.isList()) {
                this.logError(this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describeType(e), name, path), ValidationMessage.IssueSeverity.ERROR);
            }
            this.parseChildComplexInstance(npath, fpath, object, element, property, name, e);
        }
    }

    private String describeType(JsonElement e) {
        if (e.isJsonArray()) {
            return "an Array";
        }
        if (e.isJsonObject()) {
            return "an Object";
        }
        if (e.isJsonPrimitive()) {
            return "a primitive property";
        }
        if (e.isJsonNull()) {
            return "a Null";
        }
        return null;
    }

    private void parseChildComplexInstance(String npath, String fpath, JsonObject object, Element element, Property property, String name, JsonElement e) throws FHIRException {
        if (e instanceof JsonObject) {
            JsonObject child = (JsonObject)e;
            Element n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child));
            n.setPath(fpath);
            this.checkObject(child, npath);
            element.getChildren().add(n);
            if (property.isResource()) {
                this.parseResource(npath, child, n, property);
            } else {
                this.parseChildren(npath, child, n, false);
            }
        } else {
            this.logError(this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be__not_", property.isList() ? "an Array" : "an Object", this.describe(e), name, npath), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private String describe(JsonElement e) {
        if (e instanceof JsonArray) {
            return "an array";
        }
        if (e instanceof JsonObject) {
            return "an object";
        }
        if (e instanceof JsonNull) {
            return "null";
        }
        return "a primitive property";
    }

    private void parseChildPrimitive(JsonObject object, Element element, Set<String> processed, Property property, String path, String name) throws FHIRException {
        JsonElement fork;
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        processed.add(name);
        processed.add("_" + name);
        JsonElement main = object.has(name) ? object.get(name) : null;
        JsonElement jsonElement = fork = object.has("_" + name) ? object.get("_" + name) : null;
        if (main != null || fork != null) {
            if (property.isList()) {
                boolean ok = true;
                if (main != null && !(main instanceof JsonArray)) {
                    this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describe(main), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (fork != null && !(fork instanceof JsonArray)) {
                    this.logError(this.line(fork), this.col(fork), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_base_property_must_be_an_Array_not_", this.describe(main), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (ok) {
                    JsonArray arr1 = (JsonArray)main;
                    JsonArray arr2 = (JsonArray)fork;
                    for (int i = 0; i < Math.max(this.arrC(arr1), this.arrC(arr2)); ++i) {
                        JsonElement m = this.arrI(arr1, i);
                        JsonElement f = this.arrI(arr2, i);
                        this.parseChildPrimitiveInstance(element, property, name, npath, fpath, m, f);
                    }
                }
            } else {
                this.parseChildPrimitiveInstance(element, property, name, npath, fpath, main, fork);
            }
        }
    }

    private JsonElement arrI(JsonArray arr, int i) {
        return arr == null || i >= arr.size() || arr.get(i) instanceof JsonNull ? null : arr.get(i);
    }

    private int arrC(JsonArray arr) {
        return arr == null ? 0 : arr.size();
    }

    private void parseChildPrimitiveInstance(Element element, Property property, String name, String npath, String fpath, JsonElement main, JsonElement fork) throws FHIRException {
        if (main != null && !(main instanceof JsonPrimitive)) {
            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_simple_value_not_", this.describe(main), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else if (fork != null && !(fork instanceof JsonObject)) {
            this.logError(this.line(fork), this.col(fork), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(fork), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else {
            Element n = new Element(name, property).markLocation(this.line(main != null ? main : fork), this.col(main != null ? main : fork));
            n.setPath(fpath);
            element.getChildren().add(n);
            if (main != null) {
                JsonPrimitive p = (JsonPrimitive)main;
                if (p.isNumber() && p.getAsNumber() instanceof JsonTrackingParser.PresentedBigDecimal) {
                    String rawValue = ((JsonTrackingParser.PresentedBigDecimal)p.getAsNumber()).getPresentation();
                    n.setValue(rawValue);
                } else {
                    n.setValue(p.getAsString());
                }
                if (!n.getProperty().isChoice() && n.getType().equals("xhtml")) {
                    try {
                        XhtmlParser xp = new XhtmlParser();
                        n.setXhtml(xp.parse(n.getValue(), null).getDocumentElement());
                        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                            for (StringPair s : xp.getValidationIssues()) {
                                this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage(s.getName(), s.getValue()), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_XHTML_", e.getMessage()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
                if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                    if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"boolean"})) {
                        if (!p.isBoolean()) {
                            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_boolean", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"integer", "unsignedInt", "positiveInt", "decimal"})) {
                        if (!p.isNumber()) {
                            this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_number", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (!p.isString()) {
                        this.logError(this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_string", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            }
            if (fork != null) {
                JsonObject child = (JsonObject)fork;
                this.checkObject(child, npath);
                this.parseChildren(npath, child, n, false);
            }
        }
    }

    private void parseResource(String npath, JsonObject res, Element parent, Property elementProperty) throws FHIRException {
        JsonElement rt = res.get("resourceType");
        if (rt == null) {
            this.logError(this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
        } else {
            String name = rt.getAsString();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(name, this.context.getOverrideVersionNs()));
            if (sd == null) {
                this.logError(this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", name), ValidationMessage.IssueSeverity.FATAL);
            } else {
                parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
                parent.setType(name);
                this.parseChildren(npath, res, parent, true);
            }
        }
    }

    private void reapComments(JsonObject object, Element context) {
        if (object.has("fhir_comments")) {
            JsonArray arr = object.getAsJsonArray("fhir_comments");
            for (JsonElement e : arr) {
                context.getComments().add(e.getAsString());
            }
        }
    }

    private int line(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getLine();
    }

    private int col(JsonElement e) {
        if (this.map == null || !this.map.containsKey(e)) {
            return -1;
        }
        return this.map.get(e).getCol();
    }

    protected void prop(String name, String value, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String identity) throws FHIRException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : new JsonCreatorGson(osw);
        this.json.setIndent(style == IParser.OutputStyle.PRETTY ? "  " : "");
        this.json.beginObject();
        this.prop("resourceType", e.getType(), null);
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    public void compose(Element e, JsonCreator json) throws Exception {
        this.json = json;
        json.beginObject();
        this.prop("resourceType", e.getType(), this.linkResolver == null ? null : this.linkResolver.resolveProperty(e.getProperty()));
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        json.endObject();
        json.finish();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        boolean isList;
        boolean bl = isList = child.hasElementProperty() ? child.getElementProperty().isList() : child.getProperty().isList();
        if (!isList) {
            this.compose(path, child);
        } else if (!done.contains(child.getName())) {
            done.add(child.getName());
            List<Element> list = e.getChildrenByName(child.getName());
            this.composeList(path, list);
        }
    }

    private void composeList(String path, List<Element> list) throws IOException {
        Object name = list.get(0).getName();
        boolean complex = true;
        if (list.get(0).isPrimitive()) {
            boolean prim = false;
            complex = false;
            for (Element item : list) {
                if (item.hasValue()) {
                    prim = true;
                }
                if (!item.hasChildren()) continue;
                complex = true;
            }
            if (prim) {
                this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
                for (Element item : list) {
                    if (item.hasValue()) {
                        this.primitiveValue(null, item);
                        continue;
                    }
                    this.json.nullValue();
                }
                this.closeArray();
            }
            name = "_" + (String)name;
        }
        if (complex) {
            this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
            for (Element item : list) {
                if (item.hasChildren()) {
                    this.open(null, null);
                    if (item.getProperty().isResource()) {
                        this.prop("resourceType", item.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(item.getType()));
                    }
                    HashSet<String> done = new HashSet<String>();
                    for (Element child : item.getChildren()) {
                        this.compose(path + "." + (String)name + "[]", item, done, child);
                    }
                    this.close();
                    continue;
                }
                this.json.nullValue();
            }
            this.closeArray();
        }
    }

    private void primitiveValue(String name, Element item) throws IOException {
        String type;
        if (name != null) {
            if (this.linkResolver != null) {
                this.json.link(this.linkResolver.resolveProperty(item.getProperty()));
            }
            this.json.name(name);
        }
        if (Utilities.existsInList((String)(type = item.getType()), (String[])new String[]{"boolean"})) {
            this.json.value(item.getValue().trim().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            try {
                this.json.value(new BigDecimal(item.getValue()));
            }
            catch (Exception e) {
                throw new NumberFormatException(this.context.formatMessage("error_writing_number__to_JSON", item.getValue()));
            }
        } else {
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        Object name = element.getName();
        if (element.isPrimitive() || this.isPrimitive(element.getType())) {
            if (element.hasValue()) {
                this.primitiveValue((String)name, element);
            }
            name = "_" + (String)name;
            if (element.getType().equals("xhtml")) {
                this.json.anchor("end-xhtml");
            }
        }
        if (element.hasChildren()) {
            this.open((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
            if (element.getProperty().isResource()) {
                this.prop("resourceType", element.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()));
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            this.close();
        }
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public JsonParser setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
        return this;
    }
}

