/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CommunicationRequest;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DateType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;

@ResourceDef(name="Basic", profile="http://hl7.org/fhir/StructureDefinition/Basic")
public class Basic
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier assigned to the resource for business purposes, outside the context of FHIR.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Kind of Resource", formalDefinition="Identifies the 'type' of resource - equivalent to the resource name for other resources.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/basic-resource-type")
    protected CodeableConcept code;
    @Child(name="subject", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies the focus of this resource", formalDefinition="Identifies the patient, practitioner, device or any other resource that is the \"focus\" of this resource.")
    protected Reference subject;
    @Child(name="created", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When created", formalDefinition="Identifies when the resource was first created.")
    protected DateType created;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who created", formalDefinition="Indicates who was responsible for creating the resource instance.")
    protected Reference author;
    private static final long serialVersionUID = 1468819397L;
    @SearchParamDefinition(name="author", path="Basic.author", description="Who created", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Basic:author").toLocked();
    @SearchParamDefinition(name="code", path="Basic.code", description="Kind of Resource", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="created", path="Basic.created", description="When created", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="identifier", path="Basic.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Basic.subject.where(resolve() is Patient)", description="Identifies the focus of this resource", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Basic:patient").toLocked();
    @SearchParamDefinition(name="subject", path="Basic.subject", description="Identifies the focus of this resource", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Basic:subject").toLocked();

    public Basic() {
    }

    public Basic(CodeableConcept code) {
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Basic setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Basic addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Basic.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Basic setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Basic.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Basic setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public DateType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Basic.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Basic setCreatedElement(DateType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Basic setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Basic.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Basic setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned to the resource for business purposes, outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_CODE, "CodeableConcept", "Identifies the 'type' of resource - equivalent to the resource name for other resources.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "Identifies the patient, practitioner, device or any other resource that is the \"focus\" of this resource.", 0, 1, this.subject));
        children.add(new Property(SP_CREATED, "date", "Identifies when the resource was first created.", 0, 1, this.created));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Organization)", "Indicates who was responsible for creating the resource instance.", 0, 1, this.author));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned to the resource for business purposes, outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Identifies the 'type' of resource - equivalent to the resource name for other resources.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "Identifies the patient, practitioner, device or any other resource that is the \"focus\" of this resource.", 0, 1, this.subject);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "date", "Identifies when the resource was first created.", 0, 1, this.created);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Organization)", "Indicates who was responsible for creating the resource instance.", 0, 1, this.author);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.created;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.author;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDate(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = TypeConvertor.castToDate(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_CREATED)) {
            this.created = null;
        } else if (name.equals(SP_AUTHOR)) {
            this.author = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"date"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property Basic.created");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Basic";
    }

    @Override
    public Basic copy() {
        Basic dst = new Basic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Basic dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.author = this.author == null ? null : this.author.copy();
    }

    protected Basic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Basic)) {
            return false;
        }
        Basic o = (Basic)other_;
        return Basic.compareDeep(this.identifier, o.identifier, true) && Basic.compareDeep(this.code, o.code, true) && Basic.compareDeep(this.subject, o.subject, true) && Basic.compareDeep(this.created, o.created, true) && Basic.compareDeep(this.author, o.author, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Basic)) {
            return false;
        }
        Basic o = (Basic)other_;
        return Basic.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.subject, this.created, this.author});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Basic;
    }
}

