/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Account;
import org.hl7.fhir.r4b.model.ActivityDefinition;
import org.hl7.fhir.r4b.model.AdministrableProductDefinition;
import org.hl7.fhir.r4b.model.AdverseEvent;
import org.hl7.fhir.r4b.model.AllergyIntolerance;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Appointment;
import org.hl7.fhir.r4b.model.AppointmentResponse;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.AuditEvent;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Basic;
import org.hl7.fhir.r4b.model.Binary;
import org.hl7.fhir.r4b.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4b.model.BodyStructure;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CapabilityStatement;
import org.hl7.fhir.r4b.model.CarePlan;
import org.hl7.fhir.r4b.model.CareTeam;
import org.hl7.fhir.r4b.model.CatalogEntry;
import org.hl7.fhir.r4b.model.ChargeItem;
import org.hl7.fhir.r4b.model.ChargeItemDefinition;
import org.hl7.fhir.r4b.model.Citation;
import org.hl7.fhir.r4b.model.Claim;
import org.hl7.fhir.r4b.model.ClaimResponse;
import org.hl7.fhir.r4b.model.ClinicalImpression;
import org.hl7.fhir.r4b.model.ClinicalUseDefinition;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Communication;
import org.hl7.fhir.r4b.model.CompartmentDefinition;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r4b.model.Condition;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.Consent;
import org.hl7.fhir.r4b.model.Contract;
import org.hl7.fhir.r4b.model.Coverage;
import org.hl7.fhir.r4b.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4b.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DetectedIssue;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DeviceDefinition;
import org.hl7.fhir.r4b.model.DeviceMetric;
import org.hl7.fhir.r4b.model.DeviceRequest;
import org.hl7.fhir.r4b.model.DeviceUseStatement;
import org.hl7.fhir.r4b.model.DiagnosticReport;
import org.hl7.fhir.r4b.model.DocumentManifest;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Encounter;
import org.hl7.fhir.r4b.model.Endpoint;
import org.hl7.fhir.r4b.model.EnrollmentRequest;
import org.hl7.fhir.r4b.model.EnrollmentResponse;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.EpisodeOfCare;
import org.hl7.fhir.r4b.model.EventDefinition;
import org.hl7.fhir.r4b.model.Evidence;
import org.hl7.fhir.r4b.model.EvidenceReport;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.ExampleScenario;
import org.hl7.fhir.r4b.model.ExplanationOfBenefit;
import org.hl7.fhir.r4b.model.FamilyMemberHistory;
import org.hl7.fhir.r4b.model.Flag;
import org.hl7.fhir.r4b.model.Goal;
import org.hl7.fhir.r4b.model.GraphDefinition;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.GuidanceResponse;
import org.hl7.fhir.r4b.model.HealthcareService;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImagingStudy;
import org.hl7.fhir.r4b.model.Immunization;
import org.hl7.fhir.r4b.model.ImmunizationEvaluation;
import org.hl7.fhir.r4b.model.ImmunizationRecommendation;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.Ingredient;
import org.hl7.fhir.r4b.model.InsurancePlan;
import org.hl7.fhir.r4b.model.Invoice;
import org.hl7.fhir.r4b.model.Library;
import org.hl7.fhir.r4b.model.Linkage;
import org.hl7.fhir.r4b.model.ListResource;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.ManufacturedItemDefinition;
import org.hl7.fhir.r4b.model.Measure;
import org.hl7.fhir.r4b.model.MeasureReport;
import org.hl7.fhir.r4b.model.Media;
import org.hl7.fhir.r4b.model.Medication;
import org.hl7.fhir.r4b.model.MedicationAdministration;
import org.hl7.fhir.r4b.model.MedicationDispense;
import org.hl7.fhir.r4b.model.MedicationKnowledge;
import org.hl7.fhir.r4b.model.MedicationRequest;
import org.hl7.fhir.r4b.model.MedicationStatement;
import org.hl7.fhir.r4b.model.MedicinalProductDefinition;
import org.hl7.fhir.r4b.model.MessageDefinition;
import org.hl7.fhir.r4b.model.MessageHeader;
import org.hl7.fhir.r4b.model.MolecularSequence;
import org.hl7.fhir.r4b.model.NamingSystem;
import org.hl7.fhir.r4b.model.NutritionOrder;
import org.hl7.fhir.r4b.model.NutritionProduct;
import org.hl7.fhir.r4b.model.Observation;
import org.hl7.fhir.r4b.model.ObservationDefinition;
import org.hl7.fhir.r4b.model.OperationDefinition;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.OrganizationAffiliation;
import org.hl7.fhir.r4b.model.PackagedProductDefinition;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.PaymentNotice;
import org.hl7.fhir.r4b.model.PaymentReconciliation;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.Person;
import org.hl7.fhir.r4b.model.PlanDefinition;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.Procedure;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Questionnaire;
import org.hl7.fhir.r4b.model.QuestionnaireResponse;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.RegulatedAuthorization;
import org.hl7.fhir.r4b.model.RelatedPerson;
import org.hl7.fhir.r4b.model.RequestGroup;
import org.hl7.fhir.r4b.model.ResearchDefinition;
import org.hl7.fhir.r4b.model.ResearchElementDefinition;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResearchSubject;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.RiskAssessment;
import org.hl7.fhir.r4b.model.Schedule;
import org.hl7.fhir.r4b.model.SearchParameter;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.Slot;
import org.hl7.fhir.r4b.model.Specimen;
import org.hl7.fhir.r4b.model.SpecimenDefinition;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureMap;
import org.hl7.fhir.r4b.model.Subscription;
import org.hl7.fhir.r4b.model.SubscriptionStatus;
import org.hl7.fhir.r4b.model.SubscriptionTopic;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.SubstanceDefinition;
import org.hl7.fhir.r4b.model.SupplyDelivery;
import org.hl7.fhir.r4b.model.SupplyRequest;
import org.hl7.fhir.r4b.model.Task;
import org.hl7.fhir.r4b.model.TerminologyCapabilities;
import org.hl7.fhir.r4b.model.TestReport;
import org.hl7.fhir.r4b.model.TestScript;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.VerificationResult;
import org.hl7.fhir.r4b.model.VisionPrescription;

@ResourceDef(name="CommunicationRequest", profile="http://hl7.org/fhir/StructureDefinition/CommunicationRequest")
public class CommunicationRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Business identifiers assigned to this communication request by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={Reference.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan or proposal", formalDefinition="A plan or proposal that is fulfilled in whole or in part by this request.")
    protected List<Reference> basedOn;
    @Child(name="replaces", type={CommunicationRequest.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request(s) replaced by this request", formalDefinition="Completed or terminated request(s) whose function is taken by this new request.")
    protected List<Reference> replaces;
    @Child(name="groupIdentifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="The status of the proposal or order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<Enumerations.RequestStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the CommunicationRequest.")
    protected CodeableConcept statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message category", formalDefinition="The type of message to be sent such as alert, notification, reminder, instruction, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/communication-category")
    protected List<CodeableConcept> category;
    @Child(name="priority", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<Enumerations.RequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=8, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if request is prohibiting action", formalDefinition="If true indicates that the CommunicationRequest is asking for the specified action to *not* occur.")
    protected BooleanType doNotPerform;
    @Child(name="medium", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A channel of communication", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ParticipationMode")
    protected List<CodeableConcept> medium;
    @Child(name="subject", type={Patient.class, Group.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Focus of message", formalDefinition="The patient or group that is the focus of this communication request.")
    protected Reference subject;
    @Child(name="about", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Resources that pertain to this communication request", formalDefinition="Other resources that pertain to this communication request and to which this communication request should be associated.")
    protected List<Reference> about;
    @Child(name="encounter", type={Encounter.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter created as part of", formalDefinition="The Encounter during which this CommunicationRequest was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="payload", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message payload", formalDefinition="Text, attachment(s), or resource(s) to be communicated to the recipient.")
    protected List<CommunicationRequestPayloadComponent> payload;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When scheduled", formalDefinition="The time when this communication is to occur.")
    protected DataType occurrence;
    @Child(name="authoredOn", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When request transitioned to being actionable", formalDefinition="For draft requests, indicates the date of initial creation.  For requests with other statuses, indicates the date of activation.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is requesting service", formalDefinition="The device, individual, or organization who initiated the request and has responsibility for its activation.")
    protected Reference requester;
    @Child(name="recipient", type={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Group.class, CareTeam.class, HealthcareService.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message recipient", formalDefinition="The entity (e.g. person, organization, clinical information system, device, group, or care team) which is the intended target of the communication.")
    protected List<Reference> recipient;
    @Child(name="sender", type={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, HealthcareService.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message sender", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.")
    protected Reference sender;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why is communication needed?", formalDefinition="Describes why the request is being made in coded or textual form.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActReason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class, DiagnosticReport.class, DocumentReference.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why is communication needed?", formalDefinition="Indicates another resource whose existence justifies this request.")
    protected List<Reference> reasonReference;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about communication request", formalDefinition="Comments made about the request by the requester, sender, recipient, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -195979457L;
    @SearchParamDefinition(name="authored", path="CommunicationRequest.authoredOn", description="When request transitioned to being actionable", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="based-on", path="CommunicationRequest.basedOn", description="Fulfills plan or proposal", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Media.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchDefinition.class, ResearchElementDefinition.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("CommunicationRequest:based-on").toLocked();
    @SearchParamDefinition(name="category", path="CommunicationRequest.category", description="Message category", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="encounter", path="CommunicationRequest.encounter", description="Encounter created as part of", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("CommunicationRequest:encounter").toLocked();
    @SearchParamDefinition(name="group-identifier", path="CommunicationRequest.groupIdentifier", description="Composite request this is part of", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="identifier", path="CommunicationRequest.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medium", path="CommunicationRequest.medium", description="A channel of communication", type="token")
    public static final String SP_MEDIUM = "medium";
    public static final TokenClientParam MEDIUM = new TokenClientParam("medium");
    @SearchParamDefinition(name="occurrence", path="(CommunicationRequest.occurrence as dateTime)", description="When scheduled", type="date")
    public static final String SP_OCCURRENCE = "occurrence";
    public static final DateClientParam OCCURRENCE = new DateClientParam("occurrence");
    @SearchParamDefinition(name="patient", path="CommunicationRequest.subject.where(resolve() is Patient)", description="Focus of message", type="reference", target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CommunicationRequest:patient").toLocked();
    @SearchParamDefinition(name="priority", path="CommunicationRequest.priority", description="routine | urgent | asap | stat", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="recipient", path="CommunicationRequest.recipient", description="Message recipient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson"), @Compartment(name="EXAMPLE")}, target={CareTeam.class, Device.class, Group.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("CommunicationRequest:recipient").toLocked();
    @SearchParamDefinition(name="replaces", path="CommunicationRequest.replaces", description="Request(s) replaced by this request", type="reference", target={CommunicationRequest.class})
    public static final String SP_REPLACES = "replaces";
    public static final ReferenceClientParam REPLACES = new ReferenceClientParam("replaces");
    public static final Include INCLUDE_REPLACES = new Include("CommunicationRequest:replaces").toLocked();
    @SearchParamDefinition(name="requester", path="CommunicationRequest.requester", description="Who/what is requesting service", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("CommunicationRequest:requester").toLocked();
    @SearchParamDefinition(name="sender", path="CommunicationRequest.sender", description="Message sender", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson"), @Compartment(name="EXAMPLE")}, target={Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    public static final Include INCLUDE_SENDER = new Include("CommunicationRequest:sender").toLocked();
    @SearchParamDefinition(name="status", path="CommunicationRequest.status", description="draft | active | on-hold | revoked | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="CommunicationRequest.subject", description="Focus of message", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CommunicationRequest:subject").toLocked();

    public CommunicationRequest() {
    }

    public CommunicationRequest(Enumerations.RequestStatus status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CommunicationRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CommunicationRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public CommunicationRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public CommunicationRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public CommunicationRequest setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public CommunicationRequest addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public CommunicationRequest setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<Enumerations.RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CommunicationRequest setStatusElement(Enumeration<Enumerations.RequestStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.RequestStatus getStatus() {
        return this.status == null ? null : (Enumerations.RequestStatus)((Object)this.status.getValue());
    }

    public CommunicationRequest setStatus(Enumerations.RequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public CommunicationRequest setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public CommunicationRequest setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public CommunicationRequest addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public CommunicationRequest setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public Enumerations.RequestPriority getPriority() {
        return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
    }

    public CommunicationRequest setPriority(Enumerations.RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public CommunicationRequest setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public CommunicationRequest setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getMedium() {
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        return this.medium;
    }

    public CommunicationRequest setMedium(List<CodeableConcept> theMedium) {
        this.medium = theMedium;
        return this;
    }

    public boolean hasMedium() {
        if (this.medium == null) {
            return false;
        }
        for (CodeableConcept item : this.medium) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addMedium() {
        CodeableConcept t = new CodeableConcept();
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return t;
    }

    public CommunicationRequest addMedium(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return this;
    }

    public CodeableConcept getMediumFirstRep() {
        if (this.getMedium().isEmpty()) {
            this.addMedium();
        }
        return this.getMedium().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CommunicationRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getAbout() {
        if (this.about == null) {
            this.about = new ArrayList<Reference>();
        }
        return this.about;
    }

    public CommunicationRequest setAbout(List<Reference> theAbout) {
        this.about = theAbout;
        return this;
    }

    public boolean hasAbout() {
        if (this.about == null) {
            return false;
        }
        for (Reference item : this.about) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAbout() {
        Reference t = new Reference();
        if (this.about == null) {
            this.about = new ArrayList<Reference>();
        }
        this.about.add(t);
        return t;
    }

    public CommunicationRequest addAbout(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.about == null) {
            this.about = new ArrayList<Reference>();
        }
        this.about.add(t);
        return this;
    }

    public Reference getAboutFirstRep() {
        if (this.getAbout().isEmpty()) {
            this.addAbout();
        }
        return this.getAbout().get(0);
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public CommunicationRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<CommunicationRequestPayloadComponent> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        return this.payload;
    }

    public CommunicationRequest setPayload(List<CommunicationRequestPayloadComponent> thePayload) {
        this.payload = thePayload;
        return this;
    }

    public boolean hasPayload() {
        if (this.payload == null) {
            return false;
        }
        for (CommunicationRequestPayloadComponent item : this.payload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CommunicationRequestPayloadComponent addPayload() {
        CommunicationRequestPayloadComponent t = new CommunicationRequestPayloadComponent();
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        this.payload.add(t);
        return t;
    }

    public CommunicationRequest addPayload(CommunicationRequestPayloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        this.payload.add(t);
        return this;
    }

    public CommunicationRequestPayloadComponent getPayloadFirstRep() {
        if (this.getPayload().isEmpty()) {
            this.addPayload();
        }
        return this.getPayload().get(0);
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public CommunicationRequest setOccurrence(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for CommunicationRequest.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public CommunicationRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public CommunicationRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public CommunicationRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public CommunicationRequest setRecipient(List<Reference> theRecipient) {
        this.recipient = theRecipient;
        return this;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public CommunicationRequest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public Reference getRecipientFirstRep() {
        if (this.getRecipient().isEmpty()) {
            this.addRecipient();
        }
        return this.getRecipient().get(0);
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public CommunicationRequest setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public CommunicationRequest setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public CommunicationRequest addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public CommunicationRequest setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public CommunicationRequest addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public CommunicationRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public CommunicationRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this communication request by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(Any)", "A plan or proposal that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_REPLACES, "Reference(CommunicationRequest)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier));
        children.add(new Property(SP_STATUS, "code", "The status of the proposal or order.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the CommunicationRequest.", 0, 1, this.statusReason));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "The type of message to be sent such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PRIORITY, "code", "Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "If true indicates that the CommunicationRequest is asking for the specified action to *not* occur.", 0, 1, this.doNotPerform));
        children.add(new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group that is the focus of this communication request.", 0, 1, this.subject));
        children.add(new Property("about", "Reference(Any)", "Other resources that pertain to this communication request and to which this communication request should be associated.", 0, Integer.MAX_VALUE, this.about));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this CommunicationRequest was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("payload", "", "Text, attachment(s), or resource(s) to be communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload));
        children.add(new Property("occurrence[x]", "dateTime|Period", "The time when this communication is to occur.", 0, 1, this.occurrence));
        children.add(new Property("authoredOn", "dateTime", "For draft requests, indicates the date of initial creation.  For requests with other statuses, indicates the date of activation.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The device, individual, or organization who initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|Group|CareTeam|HealthcareService)", "The entity (e.g. person, organization, clinical information system, device, group, or care team) which is the intended target of the communication.", 0, Integer.MAX_VALUE, this.recipient));
        children.add(new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|HealthcareService)", "The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.", 0, 1, this.sender));
        children.add(new Property("reasonCode", "CodeableConcept", "Describes why the request is being made in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference)", "Indicates another resource whose existence justifies this request.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("note", "Annotation", "Comments made about the request by the requester, sender, recipient, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this communication request by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A plan or proposal that is fulfilled in whole or in part by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property(SP_REPLACES, "Reference(CommunicationRequest)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition, prescription or similar form.", 0, 1, this.groupIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the proposal or order.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the CommunicationRequest.", 0, 1, this.statusReason);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "The type of message to be sent such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, "code", "Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "If true indicates that the CommunicationRequest is asking for the specified action to *not* occur.", 0, 1, this.doNotPerform);
            }
            case -1078030475: {
                return new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group that is the focus of this communication request.", 0, 1, this.subject);
            }
            case 92611469: {
                return new Property("about", "Reference(Any)", "Other resources that pertain to this communication request and to which this communication request should be associated.", 0, Integer.MAX_VALUE, this.about);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this CommunicationRequest was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -786701938: {
                return new Property("payload", "", "Text, attachment(s), or resource(s) to be communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period", "The time when this communication is to occur.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period", "The time when this communication is to occur.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The time when this communication is to occur.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The time when this communication is to occur.", 0, 1, this.occurrence);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "For draft requests, indicates the date of initial creation.  For requests with other statuses, indicates the date of activation.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The device, individual, or organization who initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case 820081177: {
                return new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|Group|CareTeam|HealthcareService)", "The entity (e.g. person, organization, clinical information system, device, group, or care team) which is the intended target of the communication.", 0, Integer.MAX_VALUE, this.recipient);
            }
            case -905962955: {
                return new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|HealthcareService)", "The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.", 0, 1, this.sender);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "Describes why the request is being made in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference)", "Indicates another resource whose existence justifies this request.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the request by the requester, sender, recipient, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.statusReason;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case -1078030475: {
                return this.medium == null ? new Base[]{} : this.medium.toArray(new Base[this.medium.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 92611469: {
                return this.about == null ? new Base[]{} : this.about.toArray(new Base[this.about.size()]);
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.encounter;
                }
                return baseArray;
            }
            case -786701938: {
                return this.payload == null ? new Base[]{} : this.payload.toArray(new Base[this.payload.size()]);
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requester;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case -905962955: {
                Base[] baseArray;
                if (this.sender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.sender;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1165461084: {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1078030475: {
                this.getMedium().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 92611469: {
                this.getAbout().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -786701938: {
                this.getPayload().add((CommunicationRequestPayloadComponent)((Object)value));
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = TypeConvertor.castToReference(value);
                return value;
            }
            case 820081177: {
                this.getRecipient().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -905962955: {
                this.sender = TypeConvertor.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().add(TypeConvertor.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PRIORITY)) {
            value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_MEDIUM)) {
            this.getMedium().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("about")) {
            this.getAbout().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("payload")) {
            this.getPayload().add((CommunicationRequestPayloadComponent)((Object)value));
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SENDER)) {
            this.sender = TypeConvertor.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().remove(value);
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("statusReason")) {
            this.statusReason = null;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = null;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = null;
        } else if (name.equals(SP_MEDIUM)) {
            this.getMedium().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("about")) {
            this.getAbout().remove(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = null;
        } else if (name.equals("payload")) {
            this.getPayload().remove((CommunicationRequestPayloadComponent)value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = null;
        } else if (name.equals("authoredOn")) {
            this.authoredOn = null;
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = null;
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().remove(value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = null;
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().remove(value);
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case -1078030475: {
                return this.addMedium();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 92611469: {
                return this.addAbout();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -786701938: {
                return this.addPayload();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case -905962955: {
                return this.getSender();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case -1078030475: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 92611469: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -786701938: {
                return new String[0];
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case -905962955: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REPLACES)) {
            return this.addReplaces();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.doNotPerform");
        }
        if (name.equals(SP_MEDIUM)) {
            return this.addMedium();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("about")) {
            return this.addAbout();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("payload")) {
            return this.addPayload();
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CommunicationRequest";
    }

    @Override
    public CommunicationRequest copy() {
        CommunicationRequest dst = new CommunicationRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CommunicationRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        BooleanType booleanType = dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        if (this.medium != null) {
            dst.medium = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.medium) {
                dst.medium.add(codeableConcept3.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.about != null) {
            dst.about = new ArrayList<Reference>();
            for (Reference reference2 : this.about) {
                dst.about.add(reference2.copy());
            }
        }
        Reference reference3 = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.payload != null) {
            dst.payload = new ArrayList<CommunicationRequestPayloadComponent>();
            for (CommunicationRequestPayloadComponent communicationRequestPayloadComponent : this.payload) {
                dst.payload.add(communicationRequestPayloadComponent.copy());
            }
        }
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        Reference reference4 = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference5 : this.recipient) {
                dst.recipient.add(reference5.copy());
            }
        }
        Reference reference6 = dst.sender = this.sender == null ? null : this.sender.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.reasonCode) {
                dst.reasonCode.add(codeableConcept4.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference7 : this.reasonReference) {
                dst.reasonReference.add(reference7.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected CommunicationRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CommunicationRequest)) {
            return false;
        }
        CommunicationRequest o = (CommunicationRequest)other_;
        return CommunicationRequest.compareDeep(this.identifier, o.identifier, true) && CommunicationRequest.compareDeep(this.basedOn, o.basedOn, true) && CommunicationRequest.compareDeep(this.replaces, o.replaces, true) && CommunicationRequest.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && CommunicationRequest.compareDeep(this.status, o.status, true) && CommunicationRequest.compareDeep(this.statusReason, o.statusReason, true) && CommunicationRequest.compareDeep(this.category, o.category, true) && CommunicationRequest.compareDeep(this.priority, o.priority, true) && CommunicationRequest.compareDeep(this.doNotPerform, o.doNotPerform, true) && CommunicationRequest.compareDeep(this.medium, o.medium, true) && CommunicationRequest.compareDeep(this.subject, o.subject, true) && CommunicationRequest.compareDeep(this.about, o.about, true) && CommunicationRequest.compareDeep(this.encounter, o.encounter, true) && CommunicationRequest.compareDeep(this.payload, o.payload, true) && CommunicationRequest.compareDeep(this.occurrence, o.occurrence, true) && CommunicationRequest.compareDeep(this.authoredOn, o.authoredOn, true) && CommunicationRequest.compareDeep(this.requester, o.requester, true) && CommunicationRequest.compareDeep(this.recipient, o.recipient, true) && CommunicationRequest.compareDeep(this.sender, o.sender, true) && CommunicationRequest.compareDeep(this.reasonCode, o.reasonCode, true) && CommunicationRequest.compareDeep(this.reasonReference, o.reasonReference, true) && CommunicationRequest.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CommunicationRequest)) {
            return false;
        }
        CommunicationRequest o = (CommunicationRequest)other_;
        return CommunicationRequest.compareValues(this.status, o.status, true) && CommunicationRequest.compareValues(this.priority, o.priority, true) && CommunicationRequest.compareValues(this.doNotPerform, o.doNotPerform, true) && CommunicationRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.statusReason, this.category, this.priority, this.doNotPerform, this.medium, this.subject, this.about, this.encounter, this.payload, this.occurrence, this.authoredOn, this.requester, this.recipient, this.sender, this.reasonCode, this.reasonReference, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CommunicationRequest;
    }

    @Block
    public static class CommunicationRequestPayloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={StringType.class, Attachment.class, Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Message part content", formalDefinition="The communicated content (or for multi-part communications, one portion of the communication).")
        protected DataType content;
        private static final long serialVersionUID = -1954179063L;

        public CommunicationRequestPayloadComponent() {
        }

        public CommunicationRequestPayloadComponent(DataType content) {
            this.setContent(content);
        }

        public DataType getContent() {
            return this.content;
        }

        public StringType getContentStringType() throws FHIRException {
            if (this.content == null) {
                this.content = new StringType();
            }
            if (!(this.content instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (StringType)this.content;
        }

        public boolean hasContentStringType() {
            return this != null && this.content instanceof StringType;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                this.content = new Attachment();
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                this.content = new Reference();
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public CommunicationRequestPayloadComponent setContent(DataType value) {
            if (!(value == null || value instanceof StringType || value instanceof Attachment || value instanceof Reference)) {
                throw new Error("Not the right type for CommunicationRequest.payload.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "string|Attachment|Reference(Any)", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case -326336022: {
                    return new Property("content[x]", "string", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "Attachment", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "Reference(Any)", "The communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"string", "Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentString")) {
                this.content = new StringType();
                return this.content;
            }
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public CommunicationRequestPayloadComponent copy() {
            CommunicationRequestPayloadComponent dst = new CommunicationRequestPayloadComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CommunicationRequestPayloadComponent dst) {
            super.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CommunicationRequestPayloadComponent)) {
                return false;
            }
            CommunicationRequestPayloadComponent o = (CommunicationRequestPayloadComponent)other_;
            return CommunicationRequestPayloadComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CommunicationRequestPayloadComponent)) {
                return false;
            }
            CommunicationRequestPayloadComponent o = (CommunicationRequestPayloadComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.content});
        }

        @Override
        public String fhirType() {
            return "CommunicationRequest.payload";
        }
    }
}

