/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExampleScenario", profile="http://hl7.org/fhir/StructureDefinition/ExampleScenario")
public class ExampleScenario
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this example scenario, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the example scenario", formalDefinition="A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the example scenario", formalDefinition="The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this example scenario (computer friendly)", formalDefinition="A natural language name identifying the example scenario. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this example scenario. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the example scenario was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the example scenario.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="useContext", type={UsageContext.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for example scenario (if applicable)", formalDefinition="A legal or geographic region in which the example scenario is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="copyright", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.")
    protected MarkdownType copyright;
    @Child(name="purpose", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The purpose of the example, e.g. to illustrate a scenario", formalDefinition="What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.")
    protected MarkdownType purpose;
    @Child(name="actor", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actor participating in the resource", formalDefinition="Actor participating in the resource.")
    protected List<ExampleScenarioActorComponent> actor;
    @Child(name="instance", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Each resource and each version that is present in the workflow", formalDefinition="Each resource and each version that is present in the workflow.")
    protected List<ExampleScenarioInstanceComponent> instance;
    @Child(name="process", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Each major process - a group of operations", formalDefinition="Each major process - a group of operations.")
    protected List<ExampleScenarioProcessComponent> process;
    @Child(name="workflow", type={CanonicalType.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Another nested workflow", formalDefinition="Another nested workflow.")
    protected List<CanonicalType> workflow;
    private static final long serialVersionUID = 771935313L;
    @SearchParamDefinition(name="context-quantity", path="(ExampleScenario.useContext.value as Quantity) | (ExampleScenario.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the example scenario", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ExampleScenario.useContext", description="A use context type and quantity- or range-based value assigned to the example scenario", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ExampleScenario.useContext", description="A use context type and value assigned to the example scenario", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ExampleScenario.useContext.code", description="A type of use context assigned to the example scenario", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ExampleScenario.useContext.value as CodeableConcept)", description="A use context assigned to the example scenario", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ExampleScenario.date", description="The example scenario publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ExampleScenario.identifier", description="External identifier for the example scenario", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ExampleScenario.jurisdiction", description="Intended jurisdiction for the example scenario", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ExampleScenario.name", description="Computationally friendly name of the example scenario", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ExampleScenario.publisher", description="Name of the publisher of the example scenario", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ExampleScenario.status", description="The current status of the example scenario", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="ExampleScenario.url", description="The uri that identifies the example scenario", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ExampleScenario.version", description="The business version of the example scenario", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ExampleScenario() {
    }

    public ExampleScenario(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ExampleScenario setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ExampleScenario setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ExampleScenario setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ExampleScenario addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ExampleScenario setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ExampleScenario setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ExampleScenario setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ExampleScenario setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ExampleScenario setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ExampleScenario setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ExampleScenario setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ExampleScenario setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ExampleScenario setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ExampleScenario setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ExampleScenario setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ExampleScenario setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ExampleScenario setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ExampleScenario addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ExampleScenario setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ExampleScenario addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ExampleScenario setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ExampleScenario addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ExampleScenario setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ExampleScenario setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ExampleScenario setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ExampleScenario setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public List<ExampleScenarioActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        return this.actor;
    }

    public ExampleScenario setActor(List<ExampleScenarioActorComponent> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (ExampleScenarioActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioActorComponent addActor() {
        ExampleScenarioActorComponent t = new ExampleScenarioActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public ExampleScenario addActor(ExampleScenarioActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public ExampleScenarioActorComponent getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<ExampleScenarioInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        return this.instance;
    }

    public ExampleScenario setInstance(List<ExampleScenarioInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (ExampleScenarioInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioInstanceComponent addInstance() {
        ExampleScenarioInstanceComponent t = new ExampleScenarioInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public ExampleScenario addInstance(ExampleScenarioInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public ExampleScenarioInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<ExampleScenarioProcessComponent> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        return this.process;
    }

    public ExampleScenario setProcess(List<ExampleScenarioProcessComponent> theProcess) {
        this.process = theProcess;
        return this;
    }

    public boolean hasProcess() {
        if (this.process == null) {
            return false;
        }
        for (ExampleScenarioProcessComponent item : this.process) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioProcessComponent addProcess() {
        ExampleScenarioProcessComponent t = new ExampleScenarioProcessComponent();
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return t;
    }

    public ExampleScenario addProcess(ExampleScenarioProcessComponent t) {
        if (t == null) {
            return this;
        }
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return this;
    }

    public ExampleScenarioProcessComponent getProcessFirstRep() {
        if (this.getProcess().isEmpty()) {
            this.addProcess();
        }
        return this.getProcess().get(0);
    }

    public List<CanonicalType> getWorkflow() {
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        return this.workflow;
    }

    public ExampleScenario setWorkflow(List<CanonicalType> theWorkflow) {
        this.workflow = theWorkflow;
        return this;
    }

    public boolean hasWorkflow() {
        if (this.workflow == null) {
            return false;
        }
        for (CanonicalType item : this.workflow) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addWorkflowElement() {
        CanonicalType t = new CanonicalType();
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        this.workflow.add(t);
        return t;
    }

    public ExampleScenario addWorkflow(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        this.workflow.add(t);
        return this;
    }

    public boolean hasWorkflow(String value) {
        if (this.workflow == null) {
            return false;
        }
        for (CanonicalType v : this.workflow) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the example scenario. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the example scenario.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright));
        children.add(new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose));
        children.add(new Property("actor", "", "Actor participating in the resource.", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property("instance", "", "Each resource and each version that is present in the workflow.", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("process", "", "Each major process - a group of operations.", 0, Integer.MAX_VALUE, this.process));
        children.add(new Property("workflow", "canonical(ExampleScenario)", "Another nested workflow.", 0, Integer.MAX_VALUE, this.workflow));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the example scenario. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the example scenario.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose);
            }
            case 92645877: {
                return new Property("actor", "", "Actor participating in the resource.", 0, Integer.MAX_VALUE, this.actor);
            }
            case 555127957: {
                return new Property("instance", "", "Each resource and each version that is present in the workflow.", 0, Integer.MAX_VALUE, this.instance);
            }
            case -309518737: {
                return new Property("process", "", "Each major process - a group of operations.", 0, Integer.MAX_VALUE, this.process);
            }
            case 35379135: {
                return new Property("workflow", "canonical(ExampleScenario)", "Another nested workflow.", 0, Integer.MAX_VALUE, this.workflow);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.copyright;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -309518737: {
                return this.process == null ? new Base[]{} : this.process.toArray(new Base[this.process.size()]);
            }
            case 35379135: {
                return this.workflow == null ? new Base[]{} : this.workflow.toArray(new Base[this.workflow.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 92645877: {
                this.getActor().add((ExampleScenarioActorComponent)((Object)value));
                return value;
            }
            case 555127957: {
                this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
                return value;
            }
            case -309518737: {
                this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
                return value;
            }
            case 35379135: {
                this.getWorkflow().add(TypeConvertor.castToCanonical(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("actor")) {
            this.getActor().add((ExampleScenarioActorComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
        } else if (name.equals("process")) {
            this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
        } else if (name.equals("workflow")) {
            this.getWorkflow().add(TypeConvertor.castToCanonical(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("actor")) {
            this.getActor().remove((ExampleScenarioActorComponent)value);
        } else if (name.equals("instance")) {
            this.getInstance().remove((ExampleScenarioInstanceComponent)value);
        } else if (name.equals("process")) {
            this.getProcess().remove((ExampleScenarioProcessComponent)value);
        } else if (name.equals("workflow")) {
            this.getWorkflow().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 92645877: {
                return this.addActor();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -309518737: {
                return this.addProcess();
            }
            case 35379135: {
                return this.addWorkflowElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 92645877: {
                return new String[0];
            }
            case 555127957: {
                return new String[0];
            }
            case -309518737: {
                return new String[0];
            }
            case 35379135: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.copyright");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.purpose");
        }
        if (name.equals("actor")) {
            return this.addActor();
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("process")) {
            return this.addProcess();
        }
        if (name.equals("workflow")) {
            throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.workflow");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExampleScenario";
    }

    @Override
    public ExampleScenario copy() {
        ExampleScenario dst = new ExampleScenario();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ExampleScenario dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        MarkdownType markdownType = dst.purpose = this.purpose == null ? null : this.purpose.copy();
        if (this.actor != null) {
            dst.actor = new ArrayList<ExampleScenarioActorComponent>();
            for (ExampleScenarioActorComponent exampleScenarioActorComponent : this.actor) {
                dst.actor.add(exampleScenarioActorComponent.copy());
            }
        }
        if (this.instance != null) {
            dst.instance = new ArrayList<ExampleScenarioInstanceComponent>();
            for (ExampleScenarioInstanceComponent exampleScenarioInstanceComponent : this.instance) {
                dst.instance.add(exampleScenarioInstanceComponent.copy());
            }
        }
        if (this.process != null) {
            dst.process = new ArrayList<ExampleScenarioProcessComponent>();
            for (ExampleScenarioProcessComponent exampleScenarioProcessComponent : this.process) {
                dst.process.add(exampleScenarioProcessComponent.copy());
            }
        }
        if (this.workflow != null) {
            dst.workflow = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.workflow) {
                dst.workflow.add(canonicalType.copy());
            }
        }
    }

    protected ExampleScenario typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareDeep(this.url, o.url, true) && ExampleScenario.compareDeep(this.identifier, o.identifier, true) && ExampleScenario.compareDeep(this.version, o.version, true) && ExampleScenario.compareDeep(this.name, o.name, true) && ExampleScenario.compareDeep(this.status, o.status, true) && ExampleScenario.compareDeep(this.experimental, o.experimental, true) && ExampleScenario.compareDeep(this.date, o.date, true) && ExampleScenario.compareDeep(this.publisher, o.publisher, true) && ExampleScenario.compareDeep(this.contact, o.contact, true) && ExampleScenario.compareDeep(this.useContext, o.useContext, true) && ExampleScenario.compareDeep(this.jurisdiction, o.jurisdiction, true) && ExampleScenario.compareDeep(this.copyright, o.copyright, true) && ExampleScenario.compareDeep(this.purpose, o.purpose, true) && ExampleScenario.compareDeep(this.actor, o.actor, true) && ExampleScenario.compareDeep(this.instance, o.instance, true) && ExampleScenario.compareDeep(this.process, o.process, true) && ExampleScenario.compareDeep(this.workflow, o.workflow, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareValues(this.url, o.url, true) && ExampleScenario.compareValues(this.version, o.version, true) && ExampleScenario.compareValues(this.name, o.name, true) && ExampleScenario.compareValues(this.status, o.status, true) && ExampleScenario.compareValues(this.experimental, o.experimental, true) && ExampleScenario.compareValues(this.date, o.date, true) && ExampleScenario.compareValues(this.publisher, o.publisher, true) && ExampleScenario.compareValues(this.copyright, o.copyright, true) && ExampleScenario.compareValues(this.purpose, o.purpose, true) && ExampleScenario.compareValues(this.workflow, o.workflow, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.status, this.experimental, this.date, this.publisher, this.contact, this.useContext, this.jurisdiction, this.copyright, this.purpose, this.actor, this.instance, this.process, this.workflow});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExampleScenario;
    }

    @Override
    public String getDescription() {
        return new String();
    }

    @Override
    public MarkdownType getDescriptionElement() {
        return new MarkdownType();
    }

    @Override
    public CanonicalResource setDescription(String theDescription) {
        return this;
    }

    @Override
    public CanonicalResource setDescriptionElement(MarkdownType theDescription) {
        return this;
    }

    @Override
    public boolean hasDescription() {
        return false;
    }

    @Override
    public boolean hasDescriptionElement() {
        return false;
    }

    @Override
    public String getTitle() {
        return new String();
    }

    @Override
    public StringType getTitleElement() {
        return new StringType();
    }

    @Override
    public CanonicalResource setTitle(String theTitle) {
        return this;
    }

    @Override
    public CanonicalResource setTitleElement(StringType theTitle) {
        return this;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public boolean hasTitleElement() {
        return false;
    }

    @Block
    public static class ExampleScenarioProcessStepAlternativeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for alternative", formalDefinition="The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A human-readable description of each option", formalDefinition="A human-readable description of the alternative explaining when the alternative should occur rather than the base step.")
        protected MarkdownType description;
        @Child(name="step", type={ExampleScenarioProcessStepComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What happens in each alternative option", formalDefinition="What happens in each alternative option.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = -254687460L;

        public ExampleScenarioProcessStepAlternativeComponent() {
        }

        public ExampleScenarioProcessStepAlternativeComponent(String title) {
            this.setTitle(title);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessStepAlternativeComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessStepAlternativeComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description));
            children.add(new Property("step", "@ExampleScenario.process.step", "What happens in each alternative option.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description);
                }
                case 3540684: {
                    return new Property("step", "@ExampleScenario.process.step", "What happens in each alternative option.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("step")) {
                this.getStep().remove((ExampleScenarioProcessStepComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[]{"@ExampleScenario.process.step"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.alternative.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.alternative.description");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepAlternativeComponent copy() {
            ExampleScenarioProcessStepAlternativeComponent dst = new ExampleScenarioProcessStepAlternativeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepAlternativeComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.alternative";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The sequential number of the interaction", formalDefinition="The sequential number of the interaction, e.g. 1.2.5.")
        protected StringType number;
        @Child(name="type", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of operation - CRUD", formalDefinition="The type of operation - CRUD.")
        protected StringType type;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human-friendly name of the interaction", formalDefinition="The human-friendly name of the interaction.")
        protected StringType name;
        @Child(name="initiator", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who starts the transaction", formalDefinition="Who starts the transaction.")
        protected StringType initiator;
        @Child(name="receiver", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who receives the transaction", formalDefinition="Who receives the transaction.")
        protected StringType receiver;
        @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A comment to be inserted in the diagram", formalDefinition="A comment to be inserted in the diagram.")
        protected MarkdownType description;
        @Child(name="initiatorActive", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the initiator is deactivated right after the transaction", formalDefinition="Whether the initiator is deactivated right after the transaction.")
        protected BooleanType initiatorActive;
        @Child(name="receiverActive", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the receiver is deactivated right after the transaction", formalDefinition="Whether the receiver is deactivated right after the transaction.")
        protected BooleanType receiverActive;
        @Child(name="request", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource instance used by the initiator", formalDefinition="Each resource instance used by the initiator.")
        protected ExampleScenarioInstanceContainedInstanceComponent request;
        @Child(name="response", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource instance used by the responder", formalDefinition="Each resource instance used by the responder.")
        protected ExampleScenarioInstanceContainedInstanceComponent response;
        private static final long serialVersionUID = 911241906L;

        public ExampleScenarioProcessStepOperationComponent() {
        }

        public ExampleScenarioProcessStepOperationComponent(String number) {
            this.setNumber(number);
        }

        public StringType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new StringType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setNumberElement(StringType value) {
            this.number = value;
            return this;
        }

        public String getNumber() {
            return this.number == null ? null : (String)this.number.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setNumber(String value) {
            if (this.number == null) {
                this.number = new StringType();
            }
            this.number.setValue(value);
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getInitiatorElement() {
            if (this.initiator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiator");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiator = new StringType();
                }
            }
            return this.initiator;
        }

        public boolean hasInitiatorElement() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public boolean hasInitiator() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorElement(StringType value) {
            this.initiator = value;
            return this;
        }

        public String getInitiator() {
            return this.initiator == null ? null : (String)this.initiator.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiator(String value) {
            if (Utilities.noString((String)value)) {
                this.initiator = null;
            } else {
                if (this.initiator == null) {
                    this.initiator = new StringType();
                }
                this.initiator.setValue(value);
            }
            return this;
        }

        public StringType getReceiverElement() {
            if (this.receiver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiver");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiver = new StringType();
                }
            }
            return this.receiver;
        }

        public boolean hasReceiverElement() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public boolean hasReceiver() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverElement(StringType value) {
            this.receiver = value;
            return this;
        }

        public String getReceiver() {
            return this.receiver == null ? null : (String)this.receiver.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiver(String value) {
            if (Utilities.noString((String)value)) {
                this.receiver = null;
            } else {
                if (this.receiver == null) {
                    this.receiver = new StringType();
                }
                this.receiver.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public BooleanType getInitiatorActiveElement() {
            if (this.initiatorActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiatorActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiatorActive = new BooleanType();
                }
            }
            return this.initiatorActive;
        }

        public boolean hasInitiatorActiveElement() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public boolean hasInitiatorActive() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActiveElement(BooleanType value) {
            this.initiatorActive = value;
            return this;
        }

        public boolean getInitiatorActive() {
            return this.initiatorActive == null || this.initiatorActive.isEmpty() ? false : (Boolean)this.initiatorActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActive(boolean value) {
            if (this.initiatorActive == null) {
                this.initiatorActive = new BooleanType();
            }
            this.initiatorActive.setValue((Object)value);
            return this;
        }

        public BooleanType getReceiverActiveElement() {
            if (this.receiverActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiverActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiverActive = new BooleanType();
                }
            }
            return this.receiverActive;
        }

        public boolean hasReceiverActiveElement() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public boolean hasReceiverActive() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActiveElement(BooleanType value) {
            this.receiverActive = value;
            return this;
        }

        public boolean getReceiverActive() {
            return this.receiverActive == null || this.receiverActive.isEmpty() ? false : (Boolean)this.receiverActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActive(boolean value) {
            if (this.receiverActive == null) {
                this.receiverActive = new BooleanType();
            }
            this.receiverActive.setValue((Object)value);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setRequest(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.request = value;
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setResponse(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.response = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "string", "The sequential number of the interaction, e.g. 1.2.5.", 0, 1, this.number));
            children.add(new Property("type", "string", "The type of operation - CRUD.", 0, 1, this.type));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "The human-friendly name of the interaction.", 0, 1, this.name));
            children.add(new Property("initiator", "string", "Who starts the transaction.", 0, 1, this.initiator));
            children.add(new Property("receiver", "string", "Who receives the transaction.", 0, 1, this.receiver));
            children.add(new Property("description", "markdown", "A comment to be inserted in the diagram.", 0, 1, this.description));
            children.add(new Property("initiatorActive", "boolean", "Whether the initiator is deactivated right after the transaction.", 0, 1, this.initiatorActive));
            children.add(new Property("receiverActive", "boolean", "Whether the receiver is deactivated right after the transaction.", 0, 1, this.receiverActive));
            children.add(new Property("request", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the initiator.", 0, 1, this.request));
            children.add(new Property("response", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the responder.", 0, 1, this.response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "string", "The sequential number of the interaction, e.g. 1.2.5.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "string", "The type of operation - CRUD.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "The human-friendly name of the interaction.", 0, 1, this.name);
                }
                case -248987089: {
                    return new Property("initiator", "string", "Who starts the transaction.", 0, 1, this.initiator);
                }
                case -808719889: {
                    return new Property("receiver", "string", "Who receives the transaction.", 0, 1, this.receiver);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A comment to be inserted in the diagram.", 0, 1, this.description);
                }
                case 384339477: {
                    return new Property("initiatorActive", "boolean", "Whether the initiator is deactivated right after the transaction.", 0, 1, this.initiatorActive);
                }
                case -285284907: {
                    return new Property("receiverActive", "boolean", "Whether the receiver is deactivated right after the transaction.", 0, 1, this.receiverActive);
                }
                case 1095692943: {
                    return new Property("request", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the initiator.", 0, 1, this.request);
                }
                case -340323263: {
                    return new Property("response", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the responder.", 0, 1, this.response);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -248987089: {
                    Base[] baseArray;
                    if (this.initiator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.initiator;
                    }
                    return baseArray;
                }
                case -808719889: {
                    Base[] baseArray;
                    if (this.receiver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.receiver;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.description;
                    }
                    return baseArray;
                }
                case 384339477: {
                    Base[] baseArray;
                    if (this.initiatorActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.initiatorActive;
                    }
                    return baseArray;
                }
                case -285284907: {
                    Base[] baseArray;
                    if (this.receiverActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.receiverActive;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToString(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -248987089: {
                    this.initiator = TypeConvertor.castToString(value);
                    return value;
                }
                case -808719889: {
                    this.receiver = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 384339477: {
                    this.initiatorActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -285284907: {
                    this.receiverActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1095692943: {
                    this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
                case -340323263: {
                    this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToString(value);
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("initiator")) {
                this.initiator = TypeConvertor.castToString(value);
            } else if (name.equals("receiver")) {
                this.receiver = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("initiatorActive")) {
                this.initiatorActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("receiverActive")) {
                this.receiverActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("request")) {
                this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else if (name.equals("response")) {
                this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = null;
            } else if (name.equals("initiator")) {
                this.initiator = null;
            } else if (name.equals("receiver")) {
                this.receiver = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("initiatorActive")) {
                this.initiatorActive = null;
            } else if (name.equals("receiverActive")) {
                this.receiverActive = null;
            } else if (name.equals("request")) {
                this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else if (name.equals("response")) {
                this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -248987089: {
                    return this.getInitiatorElement();
                }
                case -808719889: {
                    return this.getReceiverElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 384339477: {
                    return this.getInitiatorActiveElement();
                }
                case -285284907: {
                    return this.getReceiverActiveElement();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"string"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -248987089: {
                    return new String[]{"string"};
                }
                case -808719889: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 384339477: {
                    return new String[]{"boolean"};
                }
                case -285284907: {
                    return new String[]{"boolean"};
                }
                case 1095692943: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
                case -340323263: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.number");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.type");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.name");
            }
            if (name.equals("initiator")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.initiator");
            }
            if (name.equals("receiver")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.receiver");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.description");
            }
            if (name.equals("initiatorActive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.initiatorActive");
            }
            if (name.equals("receiverActive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.operation.receiverActive");
            }
            if (name.equals("request")) {
                this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepOperationComponent copy() {
            ExampleScenarioProcessStepOperationComponent dst = new ExampleScenarioProcessStepOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepOperationComponent dst) {
            super.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.initiator = this.initiator == null ? null : this.initiator.copy();
            dst.receiver = this.receiver == null ? null : this.receiver.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.initiatorActive = this.initiatorActive == null ? null : this.initiatorActive.copy();
            dst.receiverActive = this.receiverActive == null ? null : this.receiverActive.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareDeep(this.number, o.number, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.type, o.type, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.name, o.name, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiverActive, o.receiverActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.request, o.request, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareValues(this.number, o.number, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.type, o.type, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.name, o.name, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiverActive, o.receiverActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.name, this.initiator, this.receiver, this.description, this.initiatorActive, this.receiverActive, this.request, this.response});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.operation";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="process", type={ExampleScenarioProcessComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested process", formalDefinition="Nested process.")
        protected List<ExampleScenarioProcessComponent> process;
        @Child(name="pause", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If there is a pause in the flow", formalDefinition="If there is a pause in the flow.")
        protected BooleanType pause;
        @Child(name="operation", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each interaction or action", formalDefinition="Each interaction or action.")
        protected ExampleScenarioProcessStepOperationComponent operation;
        @Child(name="alternative", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Alternate non-typical step action", formalDefinition="Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.")
        protected List<ExampleScenarioProcessStepAlternativeComponent> alternative;
        private static final long serialVersionUID = -894029605L;

        public List<ExampleScenarioProcessComponent> getProcess() {
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            return this.process;
        }

        public ExampleScenarioProcessStepComponent setProcess(List<ExampleScenarioProcessComponent> theProcess) {
            this.process = theProcess;
            return this;
        }

        public boolean hasProcess() {
            if (this.process == null) {
                return false;
            }
            for (ExampleScenarioProcessComponent item : this.process) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessComponent addProcess() {
            ExampleScenarioProcessComponent t = new ExampleScenarioProcessComponent();
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            this.process.add(t);
            return t;
        }

        public ExampleScenarioProcessStepComponent addProcess(ExampleScenarioProcessComponent t) {
            if (t == null) {
                return this;
            }
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            this.process.add(t);
            return this;
        }

        public ExampleScenarioProcessComponent getProcessFirstRep() {
            if (this.getProcess().isEmpty()) {
                this.addProcess();
            }
            return this.getProcess().get(0);
        }

        public BooleanType getPauseElement() {
            if (this.pause == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.pause");
                }
                if (Configuration.doAutoCreate()) {
                    this.pause = new BooleanType();
                }
            }
            return this.pause;
        }

        public boolean hasPauseElement() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public boolean hasPause() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setPauseElement(BooleanType value) {
            this.pause = value;
            return this;
        }

        public boolean getPause() {
            return this.pause == null || this.pause.isEmpty() ? false : (Boolean)this.pause.getValue();
        }

        public ExampleScenarioProcessStepComponent setPause(boolean value) {
            if (this.pause == null) {
                this.pause = new BooleanType();
            }
            this.pause.setValue((Object)value);
            return this;
        }

        public ExampleScenarioProcessStepOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new ExampleScenarioProcessStepOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setOperation(ExampleScenarioProcessStepOperationComponent value) {
            this.operation = value;
            return this;
        }

        public List<ExampleScenarioProcessStepAlternativeComponent> getAlternative() {
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            return this.alternative;
        }

        public ExampleScenarioProcessStepComponent setAlternative(List<ExampleScenarioProcessStepAlternativeComponent> theAlternative) {
            this.alternative = theAlternative;
            return this;
        }

        public boolean hasAlternative() {
            if (this.alternative == null) {
                return false;
            }
            for (ExampleScenarioProcessStepAlternativeComponent item : this.alternative) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepAlternativeComponent addAlternative() {
            ExampleScenarioProcessStepAlternativeComponent t = new ExampleScenarioProcessStepAlternativeComponent();
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return t;
        }

        public ExampleScenarioProcessStepComponent addAlternative(ExampleScenarioProcessStepAlternativeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return this;
        }

        public ExampleScenarioProcessStepAlternativeComponent getAlternativeFirstRep() {
            if (this.getAlternative().isEmpty()) {
                this.addAlternative();
            }
            return this.getAlternative().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("process", "@ExampleScenario.process", "Nested process.", 0, Integer.MAX_VALUE, this.process));
            children.add(new Property("pause", "boolean", "If there is a pause in the flow.", 0, 1, this.pause));
            children.add(new Property("operation", "", "Each interaction or action.", 0, 1, this.operation));
            children.add(new Property("alternative", "", "Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -309518737: {
                    return new Property("process", "@ExampleScenario.process", "Nested process.", 0, Integer.MAX_VALUE, this.process);
                }
                case 106440182: {
                    return new Property("pause", "boolean", "If there is a pause in the flow.", 0, 1, this.pause);
                }
                case 1662702951: {
                    return new Property("operation", "", "Each interaction or action.", 0, 1, this.operation);
                }
                case -196794451: {
                    return new Property("alternative", "", "Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return this.process == null ? new Base[]{} : this.process.toArray(new Base[this.process.size()]);
                }
                case 106440182: {
                    Base[] baseArray;
                    if (this.pause == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.pause;
                    }
                    return baseArray;
                }
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.operation;
                    }
                    return baseArray;
                }
                case -196794451: {
                    return this.alternative == null ? new Base[]{} : this.alternative.toArray(new Base[this.alternative.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    this.getProcess().add((ExampleScenarioProcessComponent)value);
                    return value;
                }
                case 106440182: {
                    this.pause = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1662702951: {
                    this.operation = (ExampleScenarioProcessStepOperationComponent)value;
                    return value;
                }
                case -196794451: {
                    this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("process")) {
                this.getProcess().add((ExampleScenarioProcessComponent)value);
            } else if (name.equals("pause")) {
                this.pause = TypeConvertor.castToBoolean(value);
            } else if (name.equals("operation")) {
                this.operation = (ExampleScenarioProcessStepOperationComponent)value;
            } else if (name.equals("alternative")) {
                this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("process")) {
                this.getProcess().remove((ExampleScenarioProcessComponent)value);
            } else if (name.equals("pause")) {
                this.pause = null;
            } else if (name.equals("operation")) {
                this.operation = (ExampleScenarioProcessStepOperationComponent)value;
            } else if (name.equals("alternative")) {
                this.getAlternative().remove((ExampleScenarioProcessStepAlternativeComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return this.addProcess();
                }
                case 106440182: {
                    return this.getPauseElement();
                }
                case 1662702951: {
                    return this.getOperation();
                }
                case -196794451: {
                    return this.addAlternative();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return new String[]{"@ExampleScenario.process"};
                }
                case 106440182: {
                    return new String[]{"boolean"};
                }
                case 1662702951: {
                    return new String[0];
                }
                case -196794451: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("process")) {
                return this.addProcess();
            }
            if (name.equals("pause")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.step.pause");
            }
            if (name.equals("operation")) {
                this.operation = new ExampleScenarioProcessStepOperationComponent();
                return this.operation;
            }
            if (name.equals("alternative")) {
                return this.addAlternative();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepComponent copy() {
            ExampleScenarioProcessStepComponent dst = new ExampleScenarioProcessStepComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepComponent dst) {
            super.copyValues(dst);
            if (this.process != null) {
                dst.process = new ArrayList<ExampleScenarioProcessComponent>();
                for (ExampleScenarioProcessComponent exampleScenarioProcessComponent : this.process) {
                    dst.process.add(exampleScenarioProcessComponent.copy());
                }
            }
            dst.pause = this.pause == null ? null : this.pause.copy();
            ExampleScenarioProcessStepOperationComponent exampleScenarioProcessStepOperationComponent = dst.operation = this.operation == null ? null : this.operation.copy();
            if (this.alternative != null) {
                dst.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
                for (ExampleScenarioProcessStepAlternativeComponent exampleScenarioProcessStepAlternativeComponent : this.alternative) {
                    dst.alternative.add(exampleScenarioProcessStepAlternativeComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareDeep(this.process, o.process, true) && ExampleScenarioProcessStepComponent.compareDeep(this.pause, o.pause, true) && ExampleScenarioProcessStepComponent.compareDeep(this.operation, o.operation, true) && ExampleScenarioProcessStepComponent.compareDeep(this.alternative, o.alternative, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareValues(this.pause, o.pause, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.process, this.pause, this.operation, this.alternative});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step";
        }
    }

    @Block
    public static class ExampleScenarioProcessComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The diagram title of the group of operations", formalDefinition="The diagram title of the group of operations.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A longer description of the group of operations", formalDefinition="A longer description of the group of operations.")
        protected MarkdownType description;
        @Child(name="preConditions", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of initial status before the process starts", formalDefinition="Description of initial status before the process starts.")
        protected MarkdownType preConditions;
        @Child(name="postConditions", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of final status after the process ends", formalDefinition="Description of final status after the process ends.")
        protected MarkdownType postConditions;
        @Child(name="step", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Each step of the process", formalDefinition="Each step of the process.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = 325578043L;

        public ExampleScenarioProcessComponent() {
        }

        public ExampleScenarioProcessComponent(String title) {
            this.setTitle(title);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public MarkdownType getPreConditionsElement() {
            if (this.preConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.preConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.preConditions = new MarkdownType();
                }
            }
            return this.preConditions;
        }

        public boolean hasPreConditionsElement() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public boolean hasPreConditions() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPreConditionsElement(MarkdownType value) {
            this.preConditions = value;
            return this;
        }

        public String getPreConditions() {
            return this.preConditions == null ? null : (String)this.preConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPreConditions(String value) {
            if (value == null) {
                this.preConditions = null;
            } else {
                if (this.preConditions == null) {
                    this.preConditions = new MarkdownType();
                }
                this.preConditions.setValue(value);
            }
            return this;
        }

        public MarkdownType getPostConditionsElement() {
            if (this.postConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.postConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.postConditions = new MarkdownType();
                }
            }
            return this.postConditions;
        }

        public boolean hasPostConditionsElement() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public boolean hasPostConditions() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPostConditionsElement(MarkdownType value) {
            this.postConditions = value;
            return this;
        }

        public String getPostConditions() {
            return this.postConditions == null ? null : (String)this.postConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPostConditions(String value) {
            if (value == null) {
                this.postConditions = null;
            } else {
                if (this.postConditions == null) {
                    this.postConditions = new MarkdownType();
                }
                this.postConditions.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The diagram title of the group of operations.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A longer description of the group of operations.", 0, 1, this.description));
            children.add(new Property("preConditions", "markdown", "Description of initial status before the process starts.", 0, 1, this.preConditions));
            children.add(new Property("postConditions", "markdown", "Description of final status after the process ends.", 0, 1, this.postConditions));
            children.add(new Property("step", "", "Each step of the process.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The diagram title of the group of operations.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A longer description of the group of operations.", 0, 1, this.description);
                }
                case -1006692933: {
                    return new Property("preConditions", "markdown", "Description of initial status before the process starts.", 0, 1, this.preConditions);
                }
                case 1738302328: {
                    return new Property("postConditions", "markdown", "Description of final status after the process ends.", 0, 1, this.postConditions);
                }
                case 3540684: {
                    return new Property("step", "", "Each step of the process.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1006692933: {
                    Base[] baseArray;
                    if (this.preConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preConditions;
                    }
                    return baseArray;
                }
                case 1738302328: {
                    Base[] baseArray;
                    if (this.postConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.postConditions;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1006692933: {
                    this.preConditions = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 1738302328: {
                    this.postConditions = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("preConditions")) {
                this.preConditions = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("postConditions")) {
                this.postConditions = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("preConditions")) {
                this.preConditions = null;
            } else if (name.equals("postConditions")) {
                this.postConditions = null;
            } else if (name.equals("step")) {
                this.getStep().remove((ExampleScenarioProcessStepComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1006692933: {
                    return this.getPreConditionsElement();
                }
                case 1738302328: {
                    return this.getPostConditionsElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1006692933: {
                    return new String[]{"markdown"};
                }
                case 1738302328: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.description");
            }
            if (name.equals("preConditions")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.preConditions");
            }
            if (name.equals("postConditions")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.process.postConditions");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessComponent copy() {
            ExampleScenarioProcessComponent dst = new ExampleScenarioProcessComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.preConditions = this.preConditions == null ? null : this.preConditions.copy();
            MarkdownType markdownType = dst.postConditions = this.postConditions == null ? null : this.postConditions.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessComponent.compareDeep(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.postConditions, o.postConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessComponent.compareValues(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareValues(this.postConditions, o.postConditions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.preConditions, this.postConditions, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process";
        }
    }

    @Block
    public static class ExampleScenarioInstanceContainedInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resourceId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource contained in the instance", formalDefinition="Each resource contained in the instance.")
        protected StringType resourceId;
        @Child(name="versionId", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A specific version of a resource contained in the instance", formalDefinition="A specific version of a resource contained in the instance.")
        protected StringType versionId;
        private static final long serialVersionUID = 908084124L;

        public ExampleScenarioInstanceContainedInstanceComponent() {
        }

        public ExampleScenarioInstanceContainedInstanceComponent(String resourceId) {
            this.setResourceId(resourceId);
        }

        public StringType getResourceIdElement() {
            if (this.resourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.resourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceId = new StringType();
                }
            }
            return this.resourceId;
        }

        public boolean hasResourceIdElement() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public boolean hasResourceId() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setResourceIdElement(StringType value) {
            this.resourceId = value;
            return this;
        }

        public String getResourceId() {
            return this.resourceId == null ? null : (String)this.resourceId.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setResourceId(String value) {
            if (this.resourceId == null) {
                this.resourceId = new StringType();
            }
            this.resourceId.setValue(value);
            return this;
        }

        public StringType getVersionIdElement() {
            if (this.versionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.versionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.versionId = new StringType();
                }
            }
            return this.versionId;
        }

        public boolean hasVersionIdElement() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public boolean hasVersionId() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionIdElement(StringType value) {
            this.versionId = value;
            return this;
        }

        public String getVersionId() {
            return this.versionId == null ? null : (String)this.versionId.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionId(String value) {
            if (Utilities.noString((String)value)) {
                this.versionId = null;
            } else {
                if (this.versionId == null) {
                    this.versionId = new StringType();
                }
                this.versionId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resourceId", "string", "Each resource contained in the instance.", 0, 1, this.resourceId));
            children.add(new Property("versionId", "string", "A specific version of a resource contained in the instance.", 0, 1, this.versionId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1345650231: {
                    return new Property("resourceId", "string", "Each resource contained in the instance.", 0, 1, this.resourceId);
                }
                case -1407102957: {
                    return new Property("versionId", "string", "A specific version of a resource contained in the instance.", 0, 1, this.versionId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    Base[] baseArray;
                    if (this.resourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resourceId;
                    }
                    return baseArray;
                }
                case -1407102957: {
                    Base[] baseArray;
                    if (this.versionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.versionId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    this.resourceId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1407102957: {
                    this.versionId = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = TypeConvertor.castToString(value);
            } else if (name.equals("versionId")) {
                this.versionId = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = null;
            } else if (name.equals("versionId")) {
                this.versionId = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return this.getResourceIdElement();
                }
                case -1407102957: {
                    return this.getVersionIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return new String[]{"string"};
                }
                case -1407102957: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resourceId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.containedInstance.resourceId");
            }
            if (name.equals("versionId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.containedInstance.versionId");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceContainedInstanceComponent copy() {
            ExampleScenarioInstanceContainedInstanceComponent dst = new ExampleScenarioInstanceContainedInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceContainedInstanceComponent dst) {
            super.copyValues(dst);
            dst.resourceId = this.resourceId == null ? null : this.resourceId.copy();
            dst.versionId = this.versionId == null ? null : this.versionId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.versionId, o.versionId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.versionId, o.versionId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.resourceId, this.versionId});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.containedInstance";
        }
    }

    @Block
    public static class ExampleScenarioInstanceVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="versionId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier of a specific version of a resource", formalDefinition="The identifier of a specific version of a resource.")
        protected StringType versionId;
        @Child(name="description", type={MarkdownType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The description of the resource version", formalDefinition="The description of the resource version.")
        protected MarkdownType description;
        private static final long serialVersionUID = 960821913L;

        public ExampleScenarioInstanceVersionComponent() {
        }

        public ExampleScenarioInstanceVersionComponent(String versionId, String description) {
            this.setVersionId(versionId);
            this.setDescription(description);
        }

        public StringType getVersionIdElement() {
            if (this.versionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.versionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.versionId = new StringType();
                }
            }
            return this.versionId;
        }

        public boolean hasVersionIdElement() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public boolean hasVersionId() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setVersionIdElement(StringType value) {
            this.versionId = value;
            return this;
        }

        public String getVersionId() {
            return this.versionId == null ? null : (String)this.versionId.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setVersionId(String value) {
            if (this.versionId == null) {
                this.versionId = new StringType();
            }
            this.versionId.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("versionId", "string", "The identifier of a specific version of a resource.", 0, 1, this.versionId));
            children.add(new Property("description", "markdown", "The description of the resource version.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1407102957: {
                    return new Property("versionId", "string", "The identifier of a specific version of a resource.", 0, 1, this.versionId);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "The description of the resource version.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    Base[] baseArray;
                    if (this.versionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.versionId;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    this.versionId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("versionId")) {
                this.versionId = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("versionId")) {
                this.versionId = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    return this.getVersionIdElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("versionId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.version.versionId");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.version.description");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceVersionComponent copy() {
            ExampleScenarioInstanceVersionComponent dst = new ExampleScenarioInstanceVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceVersionComponent dst) {
            super.copyValues(dst);
            dst.versionId = this.versionId == null ? null : this.versionId.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareDeep(this.versionId, o.versionId, true) && ExampleScenarioInstanceVersionComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareValues(this.versionId, o.versionId, true) && ExampleScenarioInstanceVersionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.versionId, this.description});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.version";
        }
    }

    @Block
    public static class ExampleScenarioInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resourceId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The id of the resource for referencing", formalDefinition="The id of the resource for referencing.")
        protected StringType resourceId;
        @Child(name="resourceType", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the resource", formalDefinition="The type of the resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType resourceType;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A short name for the resource instance", formalDefinition="A short name for the resource instance.")
        protected StringType name;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of the resource instance", formalDefinition="Human-friendly description of the resource instance.")
        protected MarkdownType description;
        @Child(name="version", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A specific version of the resource", formalDefinition="A specific version of the resource.")
        protected List<ExampleScenarioInstanceVersionComponent> version;
        @Child(name="containedInstance", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources contained in the instance", formalDefinition="Resources contained in the instance (e.g. the observations contained in a bundle).")
        protected List<ExampleScenarioInstanceContainedInstanceComponent> containedInstance;
        private static final long serialVersionUID = -1928273130L;

        public ExampleScenarioInstanceComponent() {
        }

        public ExampleScenarioInstanceComponent(String resourceId, String resourceType) {
            this.setResourceId(resourceId);
            this.setResourceType(resourceType);
        }

        public StringType getResourceIdElement() {
            if (this.resourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.resourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceId = new StringType();
                }
            }
            return this.resourceId;
        }

        public boolean hasResourceIdElement() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public boolean hasResourceId() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public ExampleScenarioInstanceComponent setResourceIdElement(StringType value) {
            this.resourceId = value;
            return this;
        }

        public String getResourceId() {
            return this.resourceId == null ? null : (String)this.resourceId.getValue();
        }

        public ExampleScenarioInstanceComponent setResourceId(String value) {
            if (this.resourceId == null) {
                this.resourceId = new StringType();
            }
            this.resourceId.setValue(value);
            return this;
        }

        public CodeType getResourceTypeElement() {
            if (this.resourceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.resourceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceType = new CodeType();
                }
            }
            return this.resourceType;
        }

        public boolean hasResourceTypeElement() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public boolean hasResourceType() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public ExampleScenarioInstanceComponent setResourceTypeElement(CodeType value) {
            this.resourceType = value;
            return this;
        }

        public String getResourceType() {
            return this.resourceType == null ? null : (String)this.resourceType.getValue();
        }

        public ExampleScenarioInstanceComponent setResourceType(String value) {
            if (this.resourceType == null) {
                this.resourceType = new CodeType();
            }
            this.resourceType.setValue(value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioInstanceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioInstanceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioInstanceVersionComponent> getVersion() {
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            return this.version;
        }

        public ExampleScenarioInstanceComponent setVersion(List<ExampleScenarioInstanceVersionComponent> theVersion) {
            this.version = theVersion;
            return this;
        }

        public boolean hasVersion() {
            if (this.version == null) {
                return false;
            }
            for (ExampleScenarioInstanceVersionComponent item : this.version) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceVersionComponent addVersion() {
            ExampleScenarioInstanceVersionComponent t = new ExampleScenarioInstanceVersionComponent();
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addVersion(ExampleScenarioInstanceVersionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return this;
        }

        public ExampleScenarioInstanceVersionComponent getVersionFirstRep() {
            if (this.getVersion().isEmpty()) {
                this.addVersion();
            }
            return this.getVersion().get(0);
        }

        public List<ExampleScenarioInstanceContainedInstanceComponent> getContainedInstance() {
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            return this.containedInstance;
        }

        public ExampleScenarioInstanceComponent setContainedInstance(List<ExampleScenarioInstanceContainedInstanceComponent> theContainedInstance) {
            this.containedInstance = theContainedInstance;
            return this;
        }

        public boolean hasContainedInstance() {
            if (this.containedInstance == null) {
                return false;
            }
            for (ExampleScenarioInstanceContainedInstanceComponent item : this.containedInstance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceContainedInstanceComponent addContainedInstance() {
            ExampleScenarioInstanceContainedInstanceComponent t = new ExampleScenarioInstanceContainedInstanceComponent();
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addContainedInstance(ExampleScenarioInstanceContainedInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getContainedInstanceFirstRep() {
            if (this.getContainedInstance().isEmpty()) {
                this.addContainedInstance();
            }
            return this.getContainedInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resourceId", "string", "The id of the resource for referencing.", 0, 1, this.resourceId));
            children.add(new Property("resourceType", "code", "The type of the resource.", 0, 1, this.resourceType));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "A short name for the resource instance.", 0, 1, this.name));
            children.add(new Property("description", "markdown", "Human-friendly description of the resource instance.", 0, 1, this.description));
            children.add(new Property(ExampleScenario.SP_VERSION, "", "A specific version of the resource.", 0, Integer.MAX_VALUE, this.version));
            children.add(new Property("containedInstance", "", "Resources contained in the instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1345650231: {
                    return new Property("resourceId", "string", "The id of the resource for referencing.", 0, 1, this.resourceId);
                }
                case -384364440: {
                    return new Property("resourceType", "code", "The type of the resource.", 0, 1, this.resourceType);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "A short name for the resource instance.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "Human-friendly description of the resource instance.", 0, 1, this.description);
                }
                case 351608024: {
                    return new Property(ExampleScenario.SP_VERSION, "", "A specific version of the resource.", 0, Integer.MAX_VALUE, this.version);
                }
                case -417062360: {
                    return new Property("containedInstance", "", "Resources contained in the instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    Base[] baseArray;
                    if (this.resourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resourceId;
                    }
                    return baseArray;
                }
                case -384364440: {
                    Base[] baseArray;
                    if (this.resourceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resourceType;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case 351608024: {
                    return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
                }
                case -417062360: {
                    return this.containedInstance == null ? new Base[]{} : this.containedInstance.toArray(new Base[this.containedInstance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    this.resourceId = TypeConvertor.castToString(value);
                    return value;
                }
                case -384364440: {
                    this.resourceType = TypeConvertor.castToCode(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 351608024: {
                    this.getVersion().add((ExampleScenarioInstanceVersionComponent)value);
                    return value;
                }
                case -417062360: {
                    this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = TypeConvertor.castToString(value);
            } else if (name.equals("resourceType")) {
                this.resourceType = TypeConvertor.castToCode(value);
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(ExampleScenario.SP_VERSION)) {
                this.getVersion().add((ExampleScenarioInstanceVersionComponent)value);
            } else if (name.equals("containedInstance")) {
                this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = null;
            } else if (name.equals("resourceType")) {
                this.resourceType = null;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals(ExampleScenario.SP_VERSION)) {
                this.getVersion().remove((ExampleScenarioInstanceVersionComponent)value);
            } else if (name.equals("containedInstance")) {
                this.getContainedInstance().remove((ExampleScenarioInstanceContainedInstanceComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return this.getResourceIdElement();
                }
                case -384364440: {
                    return this.getResourceTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 351608024: {
                    return this.addVersion();
                }
                case -417062360: {
                    return this.addContainedInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return new String[]{"string"};
                }
                case -384364440: {
                    return new String[]{"code"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 351608024: {
                    return new String[0];
                }
                case -417062360: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resourceId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.resourceId");
            }
            if (name.equals("resourceType")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.resourceType");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.instance.description");
            }
            if (name.equals(ExampleScenario.SP_VERSION)) {
                return this.addVersion();
            }
            if (name.equals("containedInstance")) {
                return this.addContainedInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceComponent copy() {
            ExampleScenarioInstanceComponent dst = new ExampleScenarioInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceComponent dst) {
            super.copyValues(dst);
            dst.resourceId = this.resourceId == null ? null : this.resourceId.copy();
            dst.resourceType = this.resourceType == null ? null : this.resourceType.copy();
            dst.name = this.name == null ? null : this.name.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.version != null) {
                dst.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
                for (ExampleScenarioInstanceVersionComponent exampleScenarioInstanceVersionComponent : this.version) {
                    dst.version.add(exampleScenarioInstanceVersionComponent.copy());
                }
            }
            if (this.containedInstance != null) {
                dst.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
                for (ExampleScenarioInstanceContainedInstanceComponent exampleScenarioInstanceContainedInstanceComponent : this.containedInstance) {
                    dst.containedInstance.add(exampleScenarioInstanceContainedInstanceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareDeep(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceComponent.compareDeep(this.resourceType, o.resourceType, true) && ExampleScenarioInstanceComponent.compareDeep(this.name, o.name, true) && ExampleScenarioInstanceComponent.compareDeep(this.description, o.description, true) && ExampleScenarioInstanceComponent.compareDeep(this.version, o.version, true) && ExampleScenarioInstanceComponent.compareDeep(this.containedInstance, o.containedInstance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareValues(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceComponent.compareValues(this.resourceType, o.resourceType, true) && ExampleScenarioInstanceComponent.compareValues(this.name, o.name, true) && ExampleScenarioInstanceComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.resourceId, this.resourceType, this.name, this.description, this.version, this.containedInstance});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance";
        }
    }

    @Block
    public static class ExampleScenarioActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actorId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ID or acronym of the actor", formalDefinition="ID or acronym of actor.")
        protected StringType actorId;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="person | entity", formalDefinition="The type of actor - person or system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/examplescenario-actor-type")
        protected Enumeration<ExampleScenarioActorType> type;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of the actor as shown in the page", formalDefinition="The name of the actor as shown in the page.")
        protected StringType name;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The description of the actor", formalDefinition="The description of the actor.")
        protected MarkdownType description;
        private static final long serialVersionUID = 1348364162L;

        public ExampleScenarioActorComponent() {
        }

        public ExampleScenarioActorComponent(String actorId, ExampleScenarioActorType type) {
            this.setActorId(actorId);
            this.setType(type);
        }

        public StringType getActorIdElement() {
            if (this.actorId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.actorId");
                }
                if (Configuration.doAutoCreate()) {
                    this.actorId = new StringType();
                }
            }
            return this.actorId;
        }

        public boolean hasActorIdElement() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public boolean hasActorId() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public ExampleScenarioActorComponent setActorIdElement(StringType value) {
            this.actorId = value;
            return this;
        }

        public String getActorId() {
            return this.actorId == null ? null : (String)this.actorId.getValue();
        }

        public ExampleScenarioActorComponent setActorId(String value) {
            if (this.actorId == null) {
                this.actorId = new StringType();
            }
            this.actorId.setValue(value);
            return this;
        }

        public Enumeration<ExampleScenarioActorType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ExampleScenarioActorType>(new ExampleScenarioActorTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioActorComponent setTypeElement(Enumeration<ExampleScenarioActorType> value) {
            this.type = value;
            return this;
        }

        public ExampleScenarioActorType getType() {
            return this.type == null ? null : (ExampleScenarioActorType)((Object)this.type.getValue());
        }

        public ExampleScenarioActorComponent setType(ExampleScenarioActorType value) {
            if (this.type == null) {
                this.type = new Enumeration<ExampleScenarioActorType>(new ExampleScenarioActorTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioActorComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioActorComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioActorComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioActorComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actorId", "string", "ID or acronym of actor.", 0, 1, this.actorId));
            children.add(new Property("type", "code", "The type of actor - person or system.", 0, 1, this.type));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "The name of the actor as shown in the page.", 0, 1, this.name));
            children.add(new Property("description", "markdown", "The description of the actor.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1161623056: {
                    return new Property("actorId", "string", "ID or acronym of actor.", 0, 1, this.actorId);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of actor - person or system.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "The name of the actor as shown in the page.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "The description of the actor.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    Base[] baseArray;
                    if (this.actorId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actorId;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    this.actorId = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new ExampleScenarioActorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actorId")) {
                this.actorId = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new ExampleScenarioActorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("actorId")) {
                this.actorId = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return this.getActorIdElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actorId")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.actorId");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.type");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ExampleScenario.actor.description");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioActorComponent copy() {
            ExampleScenarioActorComponent dst = new ExampleScenarioActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioActorComponent dst) {
            super.copyValues(dst);
            dst.actorId = this.actorId == null ? null : this.actorId.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareDeep(this.actorId, o.actorId, true) && ExampleScenarioActorComponent.compareDeep(this.type, o.type, true) && ExampleScenarioActorComponent.compareDeep(this.name, o.name, true) && ExampleScenarioActorComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareValues(this.actorId, o.actorId, true) && ExampleScenarioActorComponent.compareValues(this.type, o.type, true) && ExampleScenarioActorComponent.compareValues(this.name, o.name, true) && ExampleScenarioActorComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.actorId, this.type, this.name, this.description});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.actor";
        }
    }

    public static class ExampleScenarioActorTypeEnumFactory
    implements EnumFactory<ExampleScenarioActorType> {
        @Override
        public ExampleScenarioActorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("person".equals(codeString)) {
                return ExampleScenarioActorType.PERSON;
            }
            if ("entity".equals(codeString)) {
                return ExampleScenarioActorType.ENTITY;
            }
            throw new IllegalArgumentException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        public Enumeration<ExampleScenarioActorType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.NULL, code);
            }
            if ("person".equals(codeString)) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.PERSON, code);
            }
            if ("entity".equals(codeString)) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.ENTITY, code);
            }
            throw new FHIRException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        @Override
        public String toCode(ExampleScenarioActorType code) {
            if (code == ExampleScenarioActorType.PERSON) {
                return "person";
            }
            if (code == ExampleScenarioActorType.ENTITY) {
                return "entity";
            }
            return "?";
        }

        @Override
        public String toSystem(ExampleScenarioActorType code) {
            return code.getSystem();
        }
    }

    public static enum ExampleScenarioActorType {
        PERSON,
        ENTITY,
        NULL;


        public static ExampleScenarioActorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return PERSON;
            }
            if ("entity".equals(codeString)) {
                return ENTITY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSON: {
                    return "person";
                }
                case ENTITY: {
                    return "entity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSON: {
                    return "http://hl7.org/fhir/examplescenario-actor-type";
                }
                case ENTITY: {
                    return "http://hl7.org/fhir/examplescenario-actor-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSON: {
                    return "A person.";
                }
                case ENTITY: {
                    return "A system.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSON: {
                    return "Person";
                }
                case ENTITY: {
                    return "System";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

