/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DecimalType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Money")
public class Money
extends DataType
implements ICompositeType {
    @Child(name="value", type={DecimalType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Numerical value (with implicit precision)", formalDefinition="Numerical value (with implicit precision).")
    protected DecimalType value;
    @Child(name="currency", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ISO 4217 Currency Code", formalDefinition="ISO 4217 Currency Code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/currencies")
    protected CodeType currency;
    private static final long serialVersionUID = -484637938L;

    public DecimalType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Money.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new DecimalType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Money setValueElement(DecimalType value) {
        this.value = value;
        return this;
    }

    public BigDecimal getValue() {
        return this.value == null ? null : (BigDecimal)this.value.getValue();
    }

    public Money setValue(BigDecimal value) {
        if (value == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            this.value.setValue(value);
        }
        return this;
    }

    public Money setValue(long value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    public Money setValue(double value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    public CodeType getCurrencyElement() {
        if (this.currency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Money.currency");
            }
            if (Configuration.doAutoCreate()) {
                this.currency = new CodeType();
            }
        }
        return this.currency;
    }

    public boolean hasCurrencyElement() {
        return this.currency != null && !this.currency.isEmpty();
    }

    public boolean hasCurrency() {
        return this.currency != null && !this.currency.isEmpty();
    }

    public Money setCurrencyElement(CodeType value) {
        this.currency = value;
        return this;
    }

    public String getCurrency() {
        return this.currency == null ? null : (String)this.currency.getValue();
    }

    public Money setCurrency(String value) {
        if (Utilities.noString((String)value)) {
            this.currency = null;
        } else {
            if (this.currency == null) {
                this.currency = new CodeType();
            }
            this.currency.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "decimal", "Numerical value (with implicit precision).", 0, 1, this.value));
        children.add(new Property("currency", "code", "ISO 4217 Currency Code.", 0, 1, this.currency));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "decimal", "Numerical value (with implicit precision).", 0, 1, this.value);
            }
            case 575402001: {
                return new Property("currency", "code", "ISO 4217 Currency Code.", 0, 1, this.currency);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case 575402001: {
                Base[] baseArray;
                if (this.currency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.currency;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 575402001: {
                this.currency = TypeConvertor.castToCode(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = TypeConvertor.castToDecimal(value);
        } else if (name.equals("currency")) {
            this.currency = TypeConvertor.castToCode(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = null;
        } else if (name.equals("currency")) {
            this.currency = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case 575402001: {
                return this.getCurrencyElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"decimal"};
            }
            case 575402001: {
                return new String[]{"code"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property Money.value");
        }
        if (name.equals("currency")) {
            throw new FHIRException("Cannot call addChild on a singleton property Money.currency");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Money";
    }

    @Override
    public Money copy() {
        Money dst = new Money();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Money dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.currency = this.currency == null ? null : this.currency.copy();
    }

    protected Money typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Money)) {
            return false;
        }
        Money o = (Money)other_;
        return Money.compareDeep(this.value, o.value, true) && Money.compareDeep(this.currency, o.currency, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Money)) {
            return false;
        }
        Money o = (Money)other_;
        return Money.compareValues(this.value, o.value, true) && Money.compareValues(this.currency, o.currency, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.currency});
    }
}

