/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.app.TwoPortService;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.util.concurrent.ExecutorService;

public class DefaultHapiContext
implements HapiContext {
    private ExecutorService executorService;
    private ParserConfiguration parserConfiguration;
    private ValidationContext validationContext;
    private ValidationRuleBuilder validationRuleBuilder;
    private ModelClassFactory modelClassFactory;
    private ConnectionHub connectionHub;

    public DefaultHapiContext() {
        this(new ParserConfiguration(), ValidationContextFactory.defaultValidation(), (ModelClassFactory)new DefaultModelClassFactory());
    }

    public DefaultHapiContext(ParserConfiguration parserConfiguration, ValidationContext validationContext, ModelClassFactory modelClassFactory) {
        VersionLogger.init();
        this.parserConfiguration = parserConfiguration;
        this.validationContext = validationContext;
        this.modelClassFactory = modelClassFactory;
    }

    public DefaultHapiContext(ParserConfiguration parserConfiguration, ValidationRuleBuilder builder, ModelClassFactory modelClassFactory) {
        VersionLogger.init();
        this.parserConfiguration = parserConfiguration;
        this.validationRuleBuilder = builder;
        this.modelClassFactory = modelClassFactory;
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = DefaultExecutorService.getDefaultService();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    DefaultHapiContext.this.executorService.shutdownNow();
                }
            });
        }
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ConnectionHub getConnectionHub() {
        if (this.connectionHub == null) {
            this.connectionHub = ConnectionHub.getNewInstance(this.getExecutorService());
        }
        return this.connectionHub;
    }

    public ParserConfiguration getDefaultParserConfiguration() {
        return this.parserConfiguration;
    }

    public void setDefaultParserConfiguration(ParserConfiguration configuration) {
        this.parserConfiguration = configuration;
    }

    public ValidationContext getDefaultValidationContext() {
        return this.validationContext == null ? ValidationContextFactory.defaultValidation() : this.validationContext;
    }

    public void setDefaultValidationContext(ValidationContext context) {
        this.validationContext = context;
    }

    public void setDefaultValidationContext(String contextClassName) {
        try {
            this.validationContext = ValidationContextFactory.customValidation(contextClassName);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ValidationRuleBuilder getDefaultValidationRuleBuilder() {
        return this.validationRuleBuilder;
    }

    public void setDefaultValidationRuleBuilder(ValidationRuleBuilder validationRuleBuilder) {
        this.validationRuleBuilder = validationRuleBuilder;
    }

    public void setDefaultValidationRuleBuilder(String builderClassName) {
        try {
            this.validationRuleBuilder = ValidationContextFactory.customBuilder(builderClassName);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ModelClassFactory getDefaultModelClassFactory() {
        return this.modelClassFactory;
    }

    public void setDefaultModelClassFactory(ModelClassFactory modelClassFactory) {
        this.modelClassFactory = modelClassFactory;
    }

    public PipeParser getPipeParser() {
        return new PipeParser(this);
    }

    public XMLParser getXMLParser() {
        return new DefaultXMLParser(this);
    }

    public GenericParser getGenericParser() {
        return new GenericParser(this);
    }

    public MessageValidator getMessageValidator() {
        return new MessageValidator(this);
    }

    public HL7Service getSimpleService(int port, boolean tls) {
        return new SimpleServer(port, new MinLowerLayerProtocol(), this.getPipeParser(), tls, this.getExecutorService());
    }

    public HL7Service getTwoPortService(int port1, int port2, boolean tls) {
        return new TwoPortService(this.getPipeParser(), new MinLowerLayerProtocol(), port1, port2, tls, this.getExecutorService());
    }
}

