/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.util.XMLUtils;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;

public class VersionLogger {
    private static boolean ourInitialized = false;
    private static String ourVersion;
    private static final Logger LOG;

    private VersionLogger() {
    }

    public static void init() {
        if (!ourInitialized) {
            try {
                InputStream is = VersionLogger.class.getResourceAsStream("/ca/uhn/hl7v2/hapi-version.properties");
                Properties p = new Properties();
                p.load(is);
                ourVersion = p.getProperty("version");
                LOG.info("HAPI version is: " + ourVersion);
                DOMImplementation impl = (DOMImplementation)XMLUtils.getDOMImpl();
                if (impl == null) {
                    LOG.warn("DOM Level 3 (Load and Save) is NOT supported by the XML library found first on your classpath!");
                    LOG.warn("XML parsing and encoding as well as working with Conformance Profiles will fail.");
                }
            }
            catch (Exception e) {
                LOG.warn("Error occured while trying to retrieve a DOMImplementation.", (Throwable)e);
                LOG.warn("XML parsing and encoding as well as working with Conformance Profiles will fail.");
            }
            ourInitialized = true;
        }
    }

    public static String getVersion() {
        return ourVersion;
    }

    static {
        LOG = LoggerFactory.getLogger(VersionLogger.class);
    }
}

