/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.TestPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ConnectionDialog
extends JDialog {
    private JTextField port;
    private JTextField inPort;
    private JTextField outPort;
    private JTextField host;
    private JRadioButton onePort;
    private JCheckBox tls;
    private TestPanel testPanel;

    public ConnectionDialog(TestPanel testPanel) {
        this.testPanel = testPanel;
        this.initUI();
    }

    private void initUI() {
        Box box = new Box(1);
        this.getContentPane().add(box);
        this.host = new JTextField(20);
        JPanel hostPanel = new JPanel();
        ((FlowLayout)hostPanel.getLayout()).setAlignment(0);
        hostPanel.add(new JLabel(" Host:  "));
        hostPanel.add(this.host);
        box.add(hostPanel);
        this.onePort = new JRadioButton(" Single Port ");
        this.onePort.setSelected(true);
        this.port = new JTextField(5);
        JPanel onePortPanel = new JPanel();
        ((FlowLayout)onePortPanel.getLayout()).setAlignment(0);
        onePortPanel.add((Component)this.onePort, 0);
        onePortPanel.add(this.port);
        box.add(onePortPanel);
        JRadioButton twoPort = new JRadioButton(" Separate Inbound & Outbound Ports ");
        JPanel twoPortPanel = new JPanel();
        ((FlowLayout)twoPortPanel.getLayout()).setAlignment(0);
        twoPortPanel.add(twoPort);
        box.add(twoPortPanel);
        JPanel twoPortPanel2 = new JPanel();
        ((FlowLayout)twoPortPanel2.getLayout()).setAlignment(0);
        twoPortPanel2.add(new JLabel(" Inbound: "));
        this.inPort = new JTextField(5);
        this.inPort.setEnabled(false);
        twoPortPanel2.add(this.inPort);
        twoPortPanel2.add(new JLabel(" Outbound: "));
        this.outPort = new JTextField(5);
        this.outPort.setEnabled(false);
        twoPortPanel2.add(this.outPort);
        box.add(twoPortPanel2);
        this.tls = new JCheckBox("use TLS");
        this.tls.setSelected(false);
        box.add(this.tls);
        JPanel tlsPanel = new JPanel();
        ((FlowLayout)tlsPanel.getLayout()).setAlignment(0);
        tlsPanel.add((Component)this.tls, 0);
        box.add(tlsPanel);
        JPanel buttonPanel = new JPanel();
        JButton OK = new JButton("  OK  ");
        JButton cancel = new JButton(" Cancel ");
        buttonPanel.add(OK);
        buttonPanel.add(cancel);
        box.add(buttonPanel);
        ButtonGroup portSelect = new ButtonGroup();
        portSelect.add(twoPort);
        portSelect.add(this.onePort);
        OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.connect();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.close();
            }
        });
        this.onePort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.inPort.setEnabled(false);
                ConnectionDialog.this.outPort.setEnabled(false);
                ConnectionDialog.this.port.setEnabled(true);
            }
        });
        twoPort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.inPort.setEnabled(true);
                ConnectionDialog.this.outPort.setEnabled(true);
                ConnectionDialog.this.port.setEnabled(false);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private void connect() {
        try {
            if (this.onePort.isSelected()) {
                this.testPanel.connect(this.host.getText(), Integer.parseInt(this.port.getText()));
            } else {
                this.testPanel.connect(this.host.getText(), Integer.parseInt(this.inPort.getText()), Integer.parseInt(this.outPort.getText()));
            }
            this.close();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid port number", "", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        }
    }

    private void close() {
        this.dispose();
    }
}

