/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionData;
import ca.uhn.hl7v2.app.ConnectionFactory;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.SocketFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHub {
    private static ConnectionHub instance = null;
    private static final Logger log = LoggerFactory.getLogger(ConnectionHub.class);
    public static final String MAX_CONCURRENT_TARGETS = ConnectionHub.class.getName() + ".maxSize";
    private final ConcurrentMap<String, String> connectionMutexes = new ConcurrentHashMap<String, String>();
    private final CountingMap<ConnectionData, Connection> connections;
    private final ExecutorService executorService;

    private ConnectionHub(ExecutorService executorService) {
        this.executorService = executorService;
        this.connections = new CountingMap<ConnectionData, Connection>(){

            @Override
            protected void dispose(Connection connection) {
                connection.close();
            }

            @Override
            protected Connection open(ConnectionData connectionData) throws Exception {
                return ConnectionFactory.open(connectionData, ConnectionHub.this.executorService);
            }
        };
    }

    public Set<? extends ConnectionData> allConnections() {
        return this.connections.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection attach(ConnectionData data) throws HL7Exception {
        try {
            String mutex;
            Connection conn = null;
            this.connectionMutexes.putIfAbsent(data.toString(), data.toString());
            String string = mutex = (String)this.connectionMutexes.get(data.toString());
            synchronized (string) {
                this.discardConnectionIfStale(this.connections.get(data));
                conn = this.connections.put(data);
            }
            return conn;
        }
        catch (Exception e) {
            log.error("Failed to attach", (Throwable)e);
            throw new HL7Exception("Cannot open connection to " + data.getHost() + ":" + data.getPort() + "/" + data.getPort2(), e);
        }
    }

    public Connection attach(String host, int outboundPort, int inboundPort, Parser parser, Class<? extends LowerLayerProtocol> llpClass) throws HL7Exception {
        return this.attach(host, outboundPort, inboundPort, parser, llpClass, false);
    }

    public Connection attach(String host, int outboundPort, int inboundPort, Parser parser, Class<? extends LowerLayerProtocol> llpClass, boolean tls) throws HL7Exception {
        try {
            LowerLayerProtocol llp = llpClass.newInstance();
            return this.attach(host, outboundPort, inboundPort, parser, llp, tls);
        }
        catch (InstantiationException e) {
            throw new HL7Exception("Cannot open connection to " + host + ":" + outboundPort, e);
        }
        catch (IllegalAccessException e) {
            throw new HL7Exception("Cannot open connection to " + host + ":" + outboundPort, e);
        }
    }

    public Connection attach(String host, int outboundPort, int inboundPort, Parser parser, LowerLayerProtocol llp, boolean tls) throws HL7Exception {
        return this.attach(host, outboundPort, inboundPort, parser, llp, tls, null);
    }

    public Connection attach(String host, int outboundPort, int inboundPort, Parser parser, LowerLayerProtocol llp, boolean tls, SocketFactory socketFactory) throws HL7Exception {
        return this.attach(new ConnectionData(host, outboundPort, inboundPort, parser, llp, tls, socketFactory));
    }

    public Connection attach(String host, int port, Parser parser, Class<? extends LowerLayerProtocol> llpClass) throws HL7Exception {
        return this.attach(host, port, parser, llpClass, false);
    }

    public Connection attach(String host, int port, Parser parser, Class<? extends LowerLayerProtocol> llpClass, boolean tls) throws HL7Exception {
        return this.attach(host, port, 0, parser, llpClass, tls);
    }

    public Connection attach(String host, int port, Parser parser, LowerLayerProtocol llp) throws HL7Exception {
        return this.attach(host, port, 0, parser, llp, false);
    }

    public Connection attach(String host, int port, Parser parser, LowerLayerProtocol llp, boolean tls) throws HL7Exception {
        return this.attach(host, port, 0, parser, llp, tls);
    }

    public Connection attach(String host, int port, Parser parser, LowerLayerProtocol llp, boolean tls, SocketFactory socketFactory) throws HL7Exception {
        return this.attach(host, port, 0, parser, llp, tls, socketFactory);
    }

    public void detach(Connection c) {
        ConnectionData cd = this.connections.find(c);
        if (cd != null) {
            this.connections.remove(cd);
        }
    }

    public void discard(Connection c) {
        ConnectionData cd = this.connections.find(c);
        if (cd != null) {
            this.connections.removeAllOf(cd);
        }
    }

    public void discardAll() {
        for (ConnectionData connectionData : this.allConnections()) {
            this.connections.removeAllOf(connectionData);
        }
    }

    private void discardConnectionIfStale(Connection conn) {
        if (conn != null && !conn.isOpen()) {
            log.info("Discarding connection which appears to be closed. Remote addr: {}", (Object)conn.getRemoteAddress());
            this.discard(conn);
            conn = null;
        }
    }

    public Connection getKnownConnection(ConnectionData key) {
        return this.connections.get(key);
    }

    public boolean isOpen(ConnectionData key) {
        return this.getKnownConnection(key).isOpen();
    }

    public static ConnectionHub getInstance() {
        return ConnectionHub.getInstance(DefaultExecutorService.getDefaultService());
    }

    public static synchronized ConnectionHub getInstance(ExecutorService service) {
        if (instance == null || service.isShutdown()) {
            instance = new ConnectionHub(service);
        }
        return instance;
    }

    public static synchronized ConnectionHub getNewInstance(ExecutorService service) {
        return new ConnectionHub(service);
    }

    public static void shutdown() {
        ConnectionHub hub = ConnectionHub.getInstance();
        if (DefaultExecutorService.isDefaultService(hub.executorService)) {
            hub.executorService.shutdown();
            instance = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CountingMap<K, D> {
        private Map<K, Count> content = new ConcurrentHashMap<K, Count>();

        protected abstract void dispose(D var1);

        public K find(D value) {
            for (Map.Entry<K, Count> entry : this.content.entrySet()) {
                if (!entry.getValue().getValue().equals(value)) continue;
                return entry.getKey();
            }
            return null;
        }

        public D get(K key) {
            return this.content.containsKey(key) ? (D)this.content.get(key).getValue() : null;
        }

        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.content.keySet());
        }

        protected abstract D open(K var1) throws Exception;

        public D put(K key) throws Exception {
            if (this.content.containsKey(key)) {
                return this.content.put(key, this.content.get(key).increase()).getValue();
            }
            Count c = new Count(this.open(key));
            this.content.put(key, c);
            return c.getValue();
        }

        public D remove(K key) {
            Count pair = this.content.get(key);
            if (pair == null) {
                return null;
            }
            if (pair.isLast()) {
                return this.removeAllOf(key);
            }
            return this.content.put(key, this.content.get(key).decrease()).getValue();
        }

        public D removeAllOf(K key) {
            Object removed = this.content.remove(key).value;
            this.dispose(removed);
            return (D)removed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Count {
            private int count;
            private D value;

            public Count(D value) {
                this(value, 1);
            }

            private Count(D value, int number) {
                this.value = value;
                this.count = number;
            }

            Count decrease() {
                return !this.isLast() ? new Count(this.value, this.count - 1) : null;
            }

            public D getValue() {
                return this.value;
            }

            Count increase() {
                return new Count(this.value, this.count + 1);
            }

            boolean isLast() {
                return this.count == 1;
            }
        }
    }
}

