/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.util.idgenerator.InMemoryIDGenerator;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initiator {
    private static final Logger log = LoggerFactory.getLogger(Initiator.class);
    private static final Logger rawOutbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.outbound");
    private static final Logger rawInbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.inbound");
    private Connection conn;
    private int timeoutMillis = 10000;

    Initiator(Connection conn) throws LLPException {
        this.conn = conn;
        String timeout = System.getProperty("ca.uhn.hl7v2.app.initiator.timeout");
        if (timeout != null) {
            try {
                this.timeoutMillis = Integer.parseInt(timeout);
                log.debug("Setting Initiator timeout to {} ms", (Object)timeout);
            }
            catch (NumberFormatException e) {
                log.warn(timeout + " is not a valid integer - Initiator is using default timeout");
            }
        }
    }

    public Message sendAndReceive(Message out) throws HL7Exception, LLPException, IOException {
        if (out == null) {
            throw new HL7Exception("Can't encode null message", 101);
        }
        Terser t = new Terser(out);
        String messID = t.get("/MSH-10");
        if (messID == null || messID.length() == 0) {
            throw new HL7Exception("MSH segment missing required field Control ID (MSH-10)", 101);
        }
        String outbound = this.conn.getParser().encode(out);
        rawOutbound.debug(outbound);
        Future<String> inbound = null;
        try {
            String message = null;
            inbound = this.conn.waitForResponse(messID, this.timeoutMillis);
            this.conn.getSendWriter().writeMessage(outbound);
            if (inbound != null && (message = inbound.get()) != null) {
                log.debug("Initiator received message: {}", (Object)message);
                rawInbound.debug(message);
                Message response = this.conn.getParser().parse(message);
                log.debug("response parsed");
                return response;
            }
        }
        catch (IOException e) {
            if (inbound != null) {
                inbound.cancel(true);
            }
            this.conn.close();
            throw e;
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        throw new HL7Exception("Timeout waiting for response to message with control ID " + messID);
    }

    public void setTimeoutMillis(int timeout) {
        this.timeoutMillis = timeout;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: ca.uhn.hl7v2.app.Initiator host port");
        }
        try {
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            final PipeParser parser = new PipeParser();
            LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
            Connection connection = new Connection(parser, llp, new Socket(host, port));
            final Initiator initiator = connection.getInitiator();
            connection.activate();
            String outText = "MSH|^~\\&|||||||ACK^^ACK|||R|2.4|\rMSA|AA";
            final InMemoryIDGenerator generator = new InMemoryIDGenerator();
            for (int i = 0; i < 1000; ++i) {
                Thread sender = new Thread(new Runnable(){

                    public void run() {
                        try {
                            String ID2 = generator.getID();
                            Message out = parser.parse("MSH|^~\\&|||||||ACK^^ACK|||R|2.4|\rMSA|AA");
                            Terser tOut = new Terser(out);
                            tOut.set("/MSH-10", ID2);
                            Message in = initiator.sendAndReceive(out);
                            Terser tIn = new Terser(in);
                            String ackID = tIn.get("/MSA-2");
                            if (!ID2.equals(ackID)) {
                                throw new RuntimeException("Ack ID for message " + ID2 + " is " + ackID);
                            }
                            System.out.println("OK - ack ID matches");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                sender.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

