/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.app.ApplicationExceptionHandler;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTypeRouter
implements Application,
ApplicationExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MessageTypeRouter.class);
    private Map<String, Application> apps = new HashMap<String, Application>(20);

    public boolean canProcess(Message in) {
        try {
            Application match = this.getMatchingApplication(in);
            return match != null ? match.canProcess(in) : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Message processMessage(Message in) throws ApplicationException {
        Message out;
        try {
            Application matchingApp = this.getMatchingApplication(in);
            out = matchingApp.processMessage(in);
        }
        catch (HL7Exception e) {
            throw new ApplicationException("Error internally routing message: " + e.toString(), e);
        }
        return out;
    }

    public String processException(String incomingMessage, String outgoingMessage, Exception e) throws HL7Exception {
        String outgoingMessageResult = outgoingMessage;
        for (Application app : this.apps.values()) {
            if (!(app instanceof ApplicationExceptionHandler)) continue;
            ApplicationExceptionHandler aeh = (ApplicationExceptionHandler)app;
            outgoingMessageResult = aeh.processException(incomingMessage, outgoingMessageResult, e);
        }
        return outgoingMessageResult;
    }

    public synchronized void registerApplication(String messageType, String triggerEvent, Application handler) {
        this.apps.put(this.getKey(messageType, triggerEvent), handler);
        log.info("{} registered to handle {}^{} messages", new Object[]{handler.getClass().getName(), messageType, triggerEvent});
    }

    private Application getMatchingApplication(Message message) throws HL7Exception {
        Terser t = new Terser(message);
        String messageType = t.get("/MSH-9-1");
        String triggerEvent = t.get("/MSH-9-2");
        return this.getMatchingApplication(messageType, triggerEvent);
    }

    private synchronized Application getMatchingApplication(String messageType, String triggerEvent) {
        Application matchingApp = null;
        Application o = this.apps.get(this.getKey(messageType, triggerEvent));
        if (o == null) {
            o = this.apps.get(this.getKey(messageType, "*"));
        }
        if (o == null) {
            o = this.apps.get(this.getKey("*", triggerEvent));
        }
        if (o == null) {
            o = this.apps.get(this.getKey("*", "*"));
        }
        if (o != null) {
            matchingApp = o;
        }
        return matchingApp;
    }

    private String getKey(String messageType, String triggerEvent) {
        return messageType + "|" + triggerEvent;
    }
}

