/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutorService {
    static ExecutorService defaultExecutorService;

    public static synchronized ExecutorService getDefaultService() {
        if (defaultExecutorService == null || defaultExecutorService.isShutdown()) {
            defaultExecutorService = Executors.newCachedThreadPool();
        }
        return defaultExecutorService;
    }

    public static <V> CompletionService<V> completionService(ExecutorService executor) {
        return new ExecutorCompletionService(executor);
    }

    public static boolean isDefaultService(ExecutorService service) {
        return service == defaultExecutorService;
    }

    public static void shutdown() {
        defaultExecutorService.shutdown();
    }

    public static void shutdownNow() {
        defaultExecutorService.shutdownNow();
    }
}

