/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.CodeStore;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeStore
implements CodeStore {
    private static Logger log = LoggerFactory.getLogger(AbstractCodeStore.class);
    private WildcardPattern[] wildcards;

    public boolean isValidCode(String codeSystem, String code) {
        try {
            String[] validCodes = this.getValidCodes(codeSystem);
            boolean found = false;
            for (int i = 0; i < validCodes.length && !found; ++i) {
                if (!this.checkCode(code, validCodes[i])) continue;
                found = true;
            }
            return found;
        }
        catch (Exception e) {
            log.error("Error checking code " + code + " in code system " + codeSystem, (Throwable)e);
            return false;
        }
    }

    private boolean checkCode(String code, String pattern) {
        boolean match = false;
        if (code.equals(pattern)) {
            match = true;
        } else if (pattern.indexOf(32) >= 0 || pattern.indexOf(44) >= 0) {
            StringTokenizer tok = new StringTokenizer(pattern, ", ", false);
            while (tok.hasMoreTokens() && !match) {
                String t = tok.nextToken();
                if (t.equalsIgnoreCase("or")) continue;
                match = this.checkCode(code, t);
            }
        } else if (code.equals(pattern)) {
            match = true;
        } else {
            WildcardPattern[] wc = this.getWildcards();
            for (int i = 0; i < wc.length && !match; ++i) {
                if (!pattern.equals(wc[i].pattern)) continue;
                match = wc[i].regex.matcher(code).matches();
            }
        }
        return match;
    }

    private synchronized WildcardPattern[] getWildcards() {
        if (this.wildcards == null) {
            this.wildcards = new WildcardPattern[4];
            this.wildcards[0] = new WildcardPattern("ISOnnnn", "ISO\\d\\d\\d\\d");
            this.wildcards[1] = new WildcardPattern("HL7nnnn", "HL7\\d\\d\\d\\d");
            this.wildcards[2] = new WildcardPattern("99zzz", "99[\\w]*");
            this.wildcards[3] = new WildcardPattern("NNxxx", "99[\\w]*");
        }
        return this.wildcards;
    }

    private static class WildcardPattern {
        public String pattern;
        public Pattern regex;

        public WildcardPattern(String p, String r) {
            this.pattern = p;
            this.regex = Pattern.compile(r);
        }
    }
}

