/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.CharSetUtil;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.preparser.PreParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedMinLLPReader
implements HL7Reader {
    private static final Logger log = LoggerFactory.getLogger(ExtendedMinLLPReader.class);
    private InputStream inputStream;
    private Charset myLastCharset;
    private InputStreamReader myReader;

    public ExtendedMinLLPReader() {
    }

    public ExtendedMinLLPReader(InputStream in) throws IOException {
        this.setInputStream(in);
    }

    public synchronized void close() throws IOException {
        this.myReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Charset getCharacterEncoding(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int next = in.read();
        while ((next != -1 || bos.size() == 0) && next != 28 && next != 13) {
            bos.write(next);
            next = in.read();
        }
        bos.flush();
        try {
            String firstLine;
            if (bos.toByteArray()[0] == -2 && bos.toByteArray()[1] == -1 || bos.toByteArray()[1] == -2 && bos.toByteArray()[0] == -1) {
                if (bos.toByteArray()[1] == -2 && bos.toByteArray()[0] == -1) {
                    bos.write(0);
                }
                firstLine = bos.toString("UTF-16");
            } else {
                firstLine = bos.toString("US-ASCII");
            }
            String[] fields = PreParser.getFields(firstLine, "MSH-18(0)");
            String charset = this.stripNonLowAscii(fields[0]);
            Charset javaCs = CharSetUtil.convertHL7CharacterEncodingToCharSetvalue(charset);
            log.debug("Detected MSH-18 value \"{}\" so using charset {}", (Object)charset, (Object)javaCs.displayName());
            Charset charset2 = javaCs;
            return charset2;
        }
        catch (Exception e) {
            log.warn("Nonvalid charset - defaulting to US-ASCII", (Throwable)e);
        }
        finally {
            bos.close();
        }
        return Charset.forName("US-ASCII");
    }

    private String stripNonLowAscii(String theString) {
        if (theString == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            char next = theString.charAt(i);
            if (next <= '\u0000' || next >= '\u007f') continue;
            b.append(next);
        }
        return b.toString();
    }

    public Charset getLastCharset() {
        return this.myLastCharset;
    }

    public synchronized String getMessage() throws LLPException, IOException {
        ByteArrayOutputStream baos = null;
        baos = this.verifyAndCopyToOutputStream(this.inputStream);
        if (baos == null) {
            return null;
        }
        byte[] byteArray = baos.toByteArray();
        this.myLastCharset = this.getCharacterEncoding(new ByteArrayInputStream(byteArray));
        this.myReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byteArray), this.myLastCharset);
        baos.close();
        StringBuffer s_buffer = new StringBuffer();
        int c = this.myReader.read();
        while (c != -1) {
            s_buffer.append((char)c);
            c = this.myReader.read();
        }
        return s_buffer.toString();
    }

    public synchronized void setInputStream(InputStream in) throws IOException {
        this.inputStream = in;
    }

    private ByteArrayOutputStream verifyAndCopyToOutputStream(InputStream stream) throws IOException, LLPException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean end_of_message = false;
        int c = 0;
        try {
            c = stream.read();
        }
        catch (SocketException e) {
            log.info("SocketException on read() attempt.  Socket appears to have been closed: {}", (Object)e.getMessage());
            throw e;
        }
        catch (SocketTimeoutException e) {
            log.debug("SocketTimeoutException on read() attempt.");
            return null;
        }
        if (c == -1) {
            log.info("End of input stream reached.");
            throw new SocketException("End of input stream reached");
        }
        LowerLayerProtocol.logCharacterReceived(c);
        if (c != 11) {
            throw new LLPException("Message violates the minimal lower layer protocol: no start of message indicator received. Received: " + c);
        }
        while (!end_of_message) {
            c = stream.read();
            if (c == -1) {
                throw new LLPException("Message violates the minimal lower protocol: message terminated without a terminating character.");
            }
            LowerLayerProtocol.logCharacterReceived(c);
            if (c == 28) {
                c = stream.read();
                if (c >= 0) {
                    LowerLayerProtocol.logCharacterReceived(c);
                }
                if (c != 13) {
                    throw new LLPException("Message violates the minimal lower layer protocol: message terminator not followed by a return character.");
                }
                end_of_message = true;
                continue;
            }
            bos.write(c);
        }
        bos.flush();
        return bos;
    }
}

