/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escape;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;

public abstract class AbstractPrimitive
extends AbstractType
implements Primitive {
    private String myValue;

    public AbstractPrimitive(Message message) {
        super(message);
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String theValue) throws DataTypeException {
        Message message = this.getMessage();
        if (message != null) {
            ValidationContext context = message.getValidationContext();
            String version = message.getVersion();
            if (context != null) {
                PrimitiveTypeRule[] rules = context.getPrimitiveRules(version, this.getName(), this);
                for (int i = 0; i < rules.length; ++i) {
                    ValidationException[] ve = rules[i].apply(theValue = rules[i].correct(theValue));
                    if (ve.length <= 0) continue;
                    throw new DataTypeException(ve[0]);
                }
            }
        }
        this.myValue = theValue;
    }

    public String encode() throws HL7Exception {
        Parser p = this.getMessage().getParser();
        return p.doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void parse(String string) throws HL7Exception {
        if (string == null) {
            this.clear();
            return;
        }
        EncodingCharacters encodingCharacters = EncodingCharacters.getInstance(this.getMessage());
        char subc = encodingCharacters.getSubcomponentSeparator();
        char cmpc = encodingCharacters.getComponentSeparator();
        this.clear();
        int subcIndex = string.indexOf(subc);
        int cmpcIndex = string.indexOf(cmpc);
        if (subcIndex != -1 || cmpcIndex != -1) {
            char escapeChar;
            int index;
            if (cmpcIndex != -1) {
                index = cmpcIndex;
                escapeChar = cmpc;
            } else {
                index = subcIndex;
                escapeChar = subc;
            }
            this.setValue(string.substring(0, index));
            while (index != -1) {
                String nextSubComponent;
                int prevIndex = index + 1;
                if ((index = string.indexOf(escapeChar, prevIndex)) != -1) {
                    nextSubComponent = string.substring(prevIndex, index);
                    this.getExtraComponents().getComponent(this.getExtraComponents().numComponents()).parse(nextSubComponent);
                    continue;
                }
                nextSubComponent = string.substring(prevIndex);
                if (nextSubComponent.length() <= 0) continue;
                this.getExtraComponents().getComponent(this.getExtraComponents().numComponents()).parse(nextSubComponent);
            }
        } else {
            String escaped = Escape.unescape(string, encodingCharacters);
            this.setValue(escaped);
        }
    }

    public void clear() {
        super.clear();
        this.myValue = null;
    }

    public boolean isEmpty() {
        return (this.myValue == null || this.myValue.length() == 0) && super.isEmpty();
    }
}

