/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractStructure;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSegment
extends AbstractStructure
implements Segment {
    private static final long serialVersionUID = -6686329916234746948L;
    private List<List<Type>> fields = new ArrayList<List<Type>>();
    private List<Class<? extends Type>> types = new ArrayList<Class<? extends Type>>();
    private List<Boolean> required = new ArrayList<Boolean>();
    private List<Integer> length = new ArrayList<Integer>();
    private List<Object> args = new ArrayList<Object>();
    private List<Integer> maxReps = new ArrayList<Integer>();
    private List<String> names = new ArrayList<String>();

    public AbstractSegment(Group parent, ModelClassFactory factory) {
        super(parent);
    }

    @Override
    public Type[] getField(int number) throws HL7Exception {
        List<Type> retVal = this.getFieldAsList(number);
        return retVal.toArray(new Type[retVal.size()]);
    }

    @Override
    public boolean isEmpty() throws HL7Exception {
        for (int i = 1; i <= this.numFields(); ++i) {
            Type[] types;
            for (Type type : types = this.getField(i)) {
                if (type.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected <T extends Type> T[] getTypedField(int number, T[] array) {
        try {
            List<Type> retVal;
            List<Type> cast = retVal = this.getFieldAsList(number);
            return (Type[])cast.toArray(array);
        }
        catch (ClassCastException cce) {
            this.log.error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            this.log.error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    protected int getReps(int number) {
        try {
            return this.getFieldAsList(number).size();
        }
        catch (HL7Exception he) {
            this.log.error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    private List<Type> getFieldAsList(int number) throws HL7Exception {
        this.ensureEnoughFields(number);
        if (number < 1 || number > this.fields.size()) {
            throw new HL7Exception("Can't retrieve field " + number + " from segment " + this.getClass().getName() + " - there are only " + this.fields.size() + " fields.", 207);
        }
        return this.fields.get(number - 1);
    }

    @Override
    public Type getField(int number, int rep) throws HL7Exception {
        this.ensureEnoughFields(number);
        if (number < 1 || number > this.fields.size()) {
            throw new HL7Exception("Can't get field " + number + " in segment " + this.getName() + " - there are currently only " + this.fields.size() + " reps.", 207);
        }
        List<Type> arr = this.fields.get(number - 1);
        if (rep > arr.size()) {
            throw new HL7Exception("Can't get repetition " + rep + " from field " + number + " - there are currently only " + arr.size() + " reps.", 207);
        }
        if (rep == arr.size()) {
            Type newType = this.createNewType(number);
            arr.add(newType);
        }
        return arr.get(rep);
    }

    protected <T extends Type> T getTypedField(int number, int rep) {
        try {
            Type retVal = this.getField(number, rep);
            return (T)retVal;
        }
        catch (ClassCastException cce) {
            this.log.error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            this.log.error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    protected Type createNewTypeWithoutReflection(int field) {
        return null;
    }

    private Type createNewType(int field) throws HL7Exception {
        Type retVal = this.createNewTypeWithoutReflection(field - 1);
        if (retVal != null) {
            return retVal;
        }
        int number = field - 1;
        Class<? extends Type> c = this.types.get(number);
        Type newType = null;
        try {
            Object[] args = this.getArgs(number);
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i] instanceof Message ? Message.class : args[i].getClass();
            }
            newType = c.getConstructor(argClasses).newInstance(args);
        }
        catch (IllegalAccessException iae) {
            throw new HL7Exception("Can't access class " + c.getName() + " (" + iae.getClass().getName() + "): " + iae.getMessage(), 207);
        }
        catch (InstantiationException ie) {
            throw new HL7Exception("Can't instantiate class " + c.getName() + " (" + ie.getClass().getName() + "): " + ie.getMessage(), 207);
        }
        catch (InvocationTargetException ite) {
            throw new HL7Exception("Can't instantiate class " + c.getName() + " (" + ite.getClass().getName() + "): " + ite.getMessage(), 207);
        }
        catch (NoSuchMethodException nme) {
            throw new HL7Exception("Can't instantiate class " + c.getName() + " (" + nme.getClass().getName() + "): " + nme.getMessage(), 207);
        }
        return newType;
    }

    private Object[] getArgs(int fieldNum) {
        Object[] result = null;
        Object o = this.args.get(fieldNum);
        result = o != null && o instanceof Object[] ? (Object[])o : new Object[]{this.getMessage()};
        return result;
    }

    @Override
    public boolean isRequired(int number) throws HL7Exception {
        if (number < 1 || number > this.required.size()) {
            throw new HL7Exception("Can't retrieve optionality of field " + number + " from segment " + this.getClass().getName() + " - there are only " + this.fields.size() + " fields.", 207);
        }
        try {
            return this.required.get(number - 1);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't retrieve optionality of field " + number + ": " + e.getMessage(), 207);
        }
    }

    @Override
    public int getLength(int number) throws HL7Exception {
        if (number < 1 || number > this.length.size()) {
            throw new HL7Exception("Can't retrieve max length of field " + number + " from segment " + this.getClass().getName() + " - there are only " + this.fields.size() + " fields.", 207);
        }
        try {
            return this.length.get(number - 1);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't retrieve max length of field " + number + ": " + e.getMessage(), 207);
        }
    }

    @Override
    public int getMaxCardinality(int number) throws HL7Exception {
        if (number < 1 || number > this.length.size()) {
            throw new HL7Exception("Can't retrieve cardinality of field " + number + " from segment " + this.getClass().getName() + " - there are only " + this.fields.size() + " fields.", 207);
        }
        try {
            return this.maxReps.get(number - 1);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't retrieve max repetitions of field " + number + ": " + e.getMessage(), 207);
        }
    }

    protected void add(Class<? extends Type> c, boolean required, int maxReps, int length, Object[] constructorArgs) throws HL7Exception {
        this.add(c, required, maxReps, length, constructorArgs, null);
    }

    protected void add(Class<? extends Type> c, boolean required, int maxReps, int length, Object[] constructorArgs, String name) throws HL7Exception {
        ArrayList arr = new ArrayList();
        this.types.add(c);
        this.fields.add(arr);
        this.required.add(required);
        this.length.add(length);
        this.args.add(constructorArgs);
        this.maxReps.add(maxReps);
        this.names.add(name);
    }

    private void ensureEnoughFields(int fieldRequested) {
        int fieldsToAdd = fieldRequested - this.numFields();
        if (fieldsToAdd < 0) {
            fieldsToAdd = 0;
        }
        try {
            for (int i = 0; i < fieldsToAdd; ++i) {
                this.add(Varies.class, false, 0, 65536, null);
            }
        }
        catch (HL7Exception e) {
            this.log.error("Can't create additional generic fields to handle request for field " + fieldRequested, (Throwable)e);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public int numFields() {
        return this.fields.size();
    }

    @Override
    public String getName() {
        String fullName = this.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1, fullName.length());
    }

    @Override
    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    @Override
    public void parse(String string) throws HL7Exception {
        EncodingCharacters encodingCharacters;
        if (string == null) {
            throw new NullPointerException("String can not be null");
        }
        try {
            encodingCharacters = EncodingCharacters.getInstance(this.getMessage());
        }
        catch (HL7Exception e) {
            throw new HL7Exception("Can not invoke parse(String) on a segment if the encoding characters (MSH-1 and MSH-2) are not already correctly set on the message");
        }
        this.clear();
        this.getMessage().getParser().parse(this, string, encodingCharacters);
    }

    @Override
    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    protected Type removeRepetition(int fieldNum, int index) throws HL7Exception {
        if (fieldNum < 1 || fieldNum > this.fields.size()) {
            throw new HL7Exception("The field " + fieldNum + " does not exist in the segment " + this.getClass().getName(), 207);
        }
        String name = this.names.get(fieldNum - 1);
        List<Type> list = this.fields.get(fieldNum - 1);
        if (list.size() == 0) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " has no repetitions", 207);
        }
        if (list.size() <= index) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " must be between 0 and " + (list.size() - 1), 207);
        }
        return list.remove(index);
    }

    protected Type insertRepetition(int fieldNum, int index) throws HL7Exception {
        if (fieldNum < 1 || fieldNum > this.fields.size()) {
            throw new HL7Exception("The field " + fieldNum + " does not exist in the segment " + this.getClass().getName(), 207);
        }
        List<Type> list = this.fields.get(fieldNum - 1);
        Type newType = this.createNewType(fieldNum);
        list.add(index, newType);
        return newType;
    }

    public void clear() {
        for (List<Type> next : this.fields) {
            next.clear();
        }
    }
}

