/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.primitive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormattedTextEncoder {
    private boolean myAtStartOfLine;
    private StringBuilder myBuffer;
    private int myCurrentLineOffset;
    private int myInBold;
    private boolean myInCenter;
    private int myIndent;
    private boolean myInDiv;
    private boolean myNeedBreakBeforeNextText;
    private int myTemporaryIndent;
    private boolean myWordWrap;

    private FormattedTextEncoder() {
    }

    private void addAmpersand() {
        this.myBuffer.append("&amp;");
    }

    private void addBreak() {
        this.myBuffer.append("<br>");
    }

    private void addEndNoBreak() {
        this.myBuffer.append("</nobr>");
    }

    private void addHighAscii(char nextChar) {
        this.myBuffer.append("&#");
        this.myBuffer.append((int)nextChar);
        this.myBuffer.append(";");
    }

    private void addSpace() {
        this.myBuffer.append("&nbsp;");
    }

    private void addStartCenter() {
        this.myBuffer.append("<center>");
    }

    private void addStartNoBreak() {
        this.myBuffer.append("<nobr>");
    }

    private void closeCenterIfNeeded() {
        if (this.myInCenter) {
            this.myBuffer.append("</center>");
        }
    }

    public String encode(String theInput) {
        if (theInput == null) {
            return null;
        }
        this.myBuffer = new StringBuilder(theInput.length() + 20);
        this.myAtStartOfLine = true;
        this.myInCenter = false;
        this.myWordWrap = true;
        this.myCurrentLineOffset = 0;
        this.myTemporaryIndent = 0;
        this.myIndent = 0;
        this.myNeedBreakBeforeNextText = false;
        this.myInDiv = false;
        this.myInBold = 0;
        for (int i = 0; i < theInput.length(); ++i) {
            char nextChar = theInput.charAt(i);
            boolean handled = true;
            if (nextChar == '\\') {
                int j;
                int theStart = i + 1;
                int numericArgument = Integer.MIN_VALUE;
                int offsetIncludingNumericArgument = 0;
                String nextFourChars = theInput.substring(theStart, Math.min(theInput.length(), theStart + 4)).toLowerCase();
                if (theInput.length() >= theStart + 5) {
                    char sep = theInput.charAt(i + 4);
                    if (theInput.charAt(i + 1) == '.' && (sep == ' ' || sep == '-' || sep == '+')) {
                        String nextThirtyChars = theInput.substring(theStart + 3, Math.min(theInput.length(), theStart + 30));
                        Matcher m = Pattern.compile("^([ +-]?[0-9]+)\\\\").matcher(nextThirtyChars);
                        if (m.find()) {
                            String group = m.group(1);
                            offsetIncludingNumericArgument = group.length() + 4;
                            group = group.replace('+', ' ').trim();
                            numericArgument = Integer.parseInt(group);
                        }
                    }
                }
                if (nextFourChars.equals(".br\\")) {
                    this.closeCenterIfNeeded();
                    if (this.myNeedBreakBeforeNextText) {
                        this.addBreak();
                    }
                    this.myNeedBreakBeforeNextText = true;
                    i += 4;
                    this.myAtStartOfLine = true;
                    this.myInCenter = false;
                    this.myCurrentLineOffset = 0;
                } else if (nextFourChars.startsWith("h\\")) {
                    this.startBold();
                    i += 2;
                } else if (nextFourChars.startsWith("n\\")) {
                    this.endBold();
                    i += 2;
                } else if (nextFourChars.startsWith(".in") && this.myAtStartOfLine && numericArgument != Integer.MIN_VALUE) {
                    this.myIndent = numericArgument;
                    this.myTemporaryIndent = 0;
                    i += offsetIncludingNumericArgument;
                } else if (nextFourChars.startsWith(".ti") && this.myAtStartOfLine && numericArgument != Integer.MIN_VALUE) {
                    this.myTemporaryIndent = numericArgument;
                    i += offsetIncludingNumericArgument;
                } else if (nextFourChars.equals(".ce\\")) {
                    this.closeCenterIfNeeded();
                    if (!this.myAtStartOfLine) {
                        this.addBreak();
                    }
                    this.addStartCenter();
                    i += 4;
                    this.myAtStartOfLine = false;
                    this.myInCenter = true;
                } else if (nextFourChars.equals(".fi\\")) {
                    if (!this.myWordWrap) {
                        this.addEndNoBreak();
                        this.myWordWrap = true;
                    }
                    i += 4;
                } else if (nextFourChars.equals(".nf\\")) {
                    if (this.myWordWrap) {
                        this.addStartNoBreak();
                        this.myWordWrap = false;
                    }
                    i += 4;
                } else if (nextFourChars.startsWith(".sp")) {
                    if (nextFourChars.equals(".sp\\")) {
                        numericArgument = 1;
                        i += 4;
                    } else if (numericArgument != -1) {
                        i += offsetIncludingNumericArgument;
                    }
                    if (numericArgument > 0) {
                        for (j = 0; j < numericArgument; ++j) {
                            this.addBreak();
                        }
                        for (j = 0; j < this.myCurrentLineOffset; ++j) {
                            this.addSpace();
                        }
                    } else if (numericArgument == Integer.MIN_VALUE) {
                        handled = false;
                    }
                } else if (nextFourChars.equals(".sk ") && numericArgument >= 0) {
                    for (j = 0; j < numericArgument; ++j) {
                        this.addSpace();
                    }
                    i += offsetIncludingNumericArgument;
                } else {
                    handled = false;
                }
            } else {
                handled = false;
            }
            if (handled) continue;
            if (this.myAtStartOfLine) {
                int thisLineIndent = Math.max(0, this.myIndent + this.myTemporaryIndent);
                if (this.myNeedBreakBeforeNextText) {
                    if (this.myInDiv) {
                        this.myBuffer.append("</div>");
                    } else if (thisLineIndent == 0) {
                        this.addBreak();
                    }
                }
                if (thisLineIndent > 0) {
                    this.myBuffer.append("<div style=\"margin-left: ");
                    this.myBuffer.append(thisLineIndent);
                    this.myBuffer.append("em;\">");
                    this.myInDiv = true;
                }
            }
            if (nextChar == '&') {
                this.addAmpersand();
            } else if (nextChar >= '\u00a0') {
                this.addHighAscii(nextChar);
            } else {
                this.myBuffer.append(nextChar);
            }
            this.myAtStartOfLine = false;
            this.myNeedBreakBeforeNextText = false;
            ++this.myCurrentLineOffset;
        }
        this.endBold();
        if (!this.myWordWrap) {
            this.addEndNoBreak();
        }
        this.closeCenterIfNeeded();
        if (this.myInDiv) {
            this.myBuffer.append("</div>");
        }
        return this.myBuffer.toString();
    }

    private void endBold() {
        for (int i = 0; i < this.myInBold; ++i) {
            this.myBuffer.append("</b>");
        }
        this.myInBold = 0;
    }

    private void startBold() {
        this.myBuffer.append("<b>");
        ++this.myInBold;
    }

    public static FormattedTextEncoder getInstanceHtml() {
        return new FormattedTextEncoder();
    }
}

