/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.PipeParser;
import java.util.StringTokenizer;

public class EncodingDetector {
    private EncodingDetector() {
    }

    public static boolean isEr7Encoded(String theMessage) {
        if (theMessage.length() < 4) {
            return false;
        }
        boolean ok = true;
        if (!theMessage.startsWith("MSH")) {
            return false;
        }
        char fourthChar = theMessage.charAt(3);
        StringTokenizer st = new StringTokenizer(theMessage, String.valueOf("\r"), false);
        while (st.hasMoreTokens()) {
            String x = st.nextToken();
            if (x.length() <= 0) continue;
            if (Character.isWhitespace(x.charAt(0))) {
                x = PipeParser.stripLeadingWhitespace(x);
            }
            if (x.length() < 4 || x.charAt(3) == fourthChar) continue;
            return false;
        }
        int nextFieldDelimLoc = 0;
        for (int i = 0; i < 11; ++i) {
            if ((nextFieldDelimLoc = theMessage.indexOf(fourthChar, nextFieldDelimLoc + 1)) >= 0) continue;
            return false;
        }
        return ok;
    }

    public static boolean isXmlEncoded(String theMessage) {
        String[] expected = new String[]{"<MSH.1", "<MSH.2", "</MSH>"};
        for (int i = 0; i < expected.length; ++i) {
            if (theMessage.indexOf(expected[i]) >= 0) continue;
            return false;
        }
        return true;
    }
}

