/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.util.idgenerator.FileBasedHiLoGenerator;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfiguration {
    private String myDefaultObx2Type;
    private boolean myEncodeEmptyMandatorySegments = true;
    private Set<String> myForcedEncode = new HashSet<String>();
    private String myInvalidObx2Type;
    private IDGenerator idGenerator = new FileBasedHiLoGenerator();

    public void addForcedEncode(String theForcedEncode) {
        if (theForcedEncode == null) {
            throw new NullPointerException("forced encode may not be null");
        }
        int lastSlashIndex = theForcedEncode.lastIndexOf(47);
        if ((lastSlashIndex = Math.max(lastSlashIndex, 0)) == 0 ? !theForcedEncode.matches("[A-Z0-9]{3}(-[0-9]+){0,2}$") : lastSlashIndex == theForcedEncode.length() || !theForcedEncode.substring(lastSlashIndex + 1).matches("[A-Z0-9]{3}(-[0-9]+){0,2}$")) {
            throw new IllegalArgumentException("Definition must end with a segment name or field lookup, e.g. MSH or MSH-2");
        }
        this.myForcedEncode.add(theForcedEncode);
    }

    public void removeForcedEncode(String theForcedEncode) {
        if (theForcedEncode == null) {
            throw new NullPointerException("forced encode may not be null");
        }
        this.myForcedEncode.remove(theForcedEncode);
    }

    boolean determineForcedEncodeIncludesTerserPath(String theTerserPath) {
        for (String next : this.getForcedEncode()) {
            if (!next.startsWith(theTerserPath)) continue;
            return true;
        }
        return false;
    }

    int determineForcedFieldNumForTerserPath(String theCurrentTerserPath) {
        int forceUpToFieldNum = 0;
        for (String nextPath : this.getForcedEncode()) {
            if (!nextPath.startsWith(theCurrentTerserPath) || nextPath.length() <= theCurrentTerserPath.length()) continue;
            int endOfFieldDef = nextPath.indexOf(45, theCurrentTerserPath.length() + 1);
            if (endOfFieldDef == -1) {
                endOfFieldDef = nextPath.length();
            }
            String fieldNumString = nextPath.substring(theCurrentTerserPath.length() + 1, endOfFieldDef);
            forceUpToFieldNum = Math.max(forceUpToFieldNum, Integer.parseInt(fieldNumString));
        }
        return forceUpToFieldNum;
    }

    public String getDefaultObx2Type() {
        return this.myDefaultObx2Type;
    }

    public Set<String> getForcedEncode() {
        return Collections.unmodifiableSet(this.myForcedEncode);
    }

    public boolean isEncodeEmptyMandatorySegments() {
        return this.myEncodeEmptyMandatorySegments;
    }

    public String getInvalidObx2Type() {
        return this.myInvalidObx2Type;
    }

    public void setDefaultObx2Type(String theDefaultObx2Type) {
        this.myDefaultObx2Type = theDefaultObx2Type;
    }

    public void setEncodeEmptyMandatoryFirstSegments(boolean theEncodeEmptyMandatorySegments) {
        this.myEncodeEmptyMandatorySegments = theEncodeEmptyMandatorySegments;
    }

    public void setInvalidObx2Type(String theInvalidObx2Type) {
        this.myInvalidObx2Type = theInvalidObx2Type;
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

