/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingDetector;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.util.XMLUtils;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XMLParser
extends Parser {
    private static final Logger log = LoggerFactory.getLogger(XMLParser.class);
    private String textEncoding;
    private String[] keepAsOriginalNodes;
    private String concatKeepAsOriginalNodes = "";

    public XMLParser() {
    }

    public XMLParser(HapiContext context) {
        super(context);
    }

    public XMLParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    public String getEncoding(String message) {
        return EncodingDetector.isXmlEncoded(message) ? this.getDefaultEncoding() : null;
    }

    public String getDefaultEncoding() {
        return "XML";
    }

    public void setKeepAsOriginalNodes(String[] keepAsOriginalNodes) {
        this.keepAsOriginalNodes = keepAsOriginalNodes;
        if (keepAsOriginalNodes.length != 0) {
            StringBuffer strBuf = new StringBuffer(keepAsOriginalNodes[0]);
            for (int i = 1; i < keepAsOriginalNodes.length; ++i) {
                strBuf.append("|");
                strBuf.append(keepAsOriginalNodes[i]);
            }
            this.concatKeepAsOriginalNodes = strBuf.toString();
        } else {
            this.concatKeepAsOriginalNodes = "";
        }
    }

    public String[] getKeepAsOriginalNodes() {
        return this.keepAsOriginalNodes;
    }

    public abstract Message parseDocument(Document var1, String var2) throws HL7Exception;

    protected Message doParse(String message, String version) throws HL7Exception, EncodingNotSupportedException {
        Message m = null;
        Document doc = null;
        doc = this.parseStringIntoDocument(message);
        m = this.parseDocument(doc, version);
        return m;
    }

    protected synchronized Document parseStringIntoDocument(String message) throws HL7Exception {
        try {
            return XMLUtils.parse(message);
        }
        catch (Exception e) {
            throw new HL7Exception("Exception parsing XML", 207, e);
        }
    }

    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        if (!encoding.equals("XML")) {
            throw new EncodingNotSupportedException("XMLParser supports only XML encoding");
        }
        return this.encode(source);
    }

    protected String doEncode(Message source) throws HL7Exception {
        if (source instanceof GenericMessage) {
            throw new HL7Exception("Can't XML-encode a GenericMessage.  Message must have a recognized structure.");
        }
        Document doc = this.encodeDocument(source);
        try {
            return XMLUtils.serialize(doc);
        }
        catch (Exception e) {
            throw new HL7Exception("Exception serializing XML document to string", 207, e);
        }
    }

    public abstract Document encodeDocument(Message var1) throws HL7Exception;

    public void parse(Segment segmentObject, Element segmentElement) throws HL7Exception {
        HashSet<String> done = new HashSet<String>();
        NodeList all = segmentElement.getChildNodes();
        for (int i = 0; i < all.getLength(); ++i) {
            String elementName = all.item(i).getNodeName();
            if (all.item(i).getNodeType() != 1 || done.contains(elementName)) continue;
            done.add(elementName);
            int index = elementName.indexOf(46);
            if (index >= 0 && elementName.length() > index) {
                String fieldNumString = elementName.substring(index + 1);
                int fieldNum = Integer.parseInt(fieldNumString);
                this.parseReps(segmentObject, segmentElement, elementName, fieldNum);
                continue;
            }
            log.debug("Child of segment {} doesn't look like a field {}", (Object)segmentObject.getName(), (Object)elementName);
        }
        if (segmentObject.getClass().getName().indexOf("OBX") >= 0) {
            Varies.fixOBX5(segmentObject, this.getFactory());
        }
    }

    private void parseReps(Segment segmentObject, Element segmentElement, String fieldName, int fieldNum) throws DataTypeException, HL7Exception {
        NodeList reps = segmentElement.getElementsByTagName(fieldName);
        for (int i = 0; i < reps.getLength(); ++i) {
            this.parse(segmentObject.getField(fieldNum, i), (Element)reps.item(i));
        }
    }

    public boolean encode(Segment segmentObject, Element segmentElement) throws HL7Exception {
        boolean hasValue = false;
        int n = segmentObject.numFields();
        for (int i = 1; i <= n; ++i) {
            String name = this.makeElementName(segmentObject, i);
            Type[] reps = segmentObject.getField(i);
            for (int j = 0; j < reps.length; ++j) {
                Element newNode = segmentElement.getOwnerDocument().createElement(name);
                boolean componentHasValue = this.encode(reps[j], newNode);
                if (!componentHasValue) continue;
                try {
                    segmentElement.appendChild(newNode);
                }
                catch (DOMException e) {
                    throw new HL7Exception("DOMException encoding Segment: ", 207, e);
                }
                hasValue = true;
            }
        }
        return hasValue;
    }

    public void parse(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof Varies) {
            this.parseVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            this.parsePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            this.parseComposite((Composite)datatypeObject, datatypeElement);
        }
    }

    private void parseVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        if (!this.hasChildElement(datatypeElement)) {
            datatypeObject.setData(new GenericPrimitive(datatypeObject.getMessage()));
        } else {
            datatypeObject.setData(new GenericComposite(datatypeObject.getMessage()));
        }
        this.parse(datatypeObject.getData(), datatypeElement);
    }

    private boolean hasChildElement(Element e) {
        NodeList children = e.getChildNodes();
        boolean hasElement = false;
        for (int c = 0; c < children.getLength() && !hasElement; ++c) {
            if (children.item(c).getNodeType() != 1) continue;
            hasElement = true;
        }
        return hasElement;
    }

    private void parsePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        NodeList children = datatypeElement.getChildNodes();
        int c = 0;
        boolean full = false;
        while (c < children.getLength() && !full) {
            Node child;
            if ((child = children.item(c++)).getNodeType() != 3) continue;
            try {
                if (child.getNodeValue() != null && !child.getNodeValue().equals("")) {
                    if (this.keepAsOriginal(child.getParentNode())) {
                        datatypeObject.setValue(child.getNodeValue());
                    } else {
                        datatypeObject.setValue(this.removeWhitespace(child.getNodeValue()));
                    }
                }
            }
            catch (DOMException e) {
                log.error("Error parsing primitive value from TEXT_NODE", (Throwable)e);
            }
            full = true;
        }
    }

    protected boolean keepAsOriginal(Node node) {
        if (node.getNodeName() == null) {
            return false;
        }
        return this.concatKeepAsOriginalNodes.indexOf(node.getNodeName()) != -1;
    }

    protected String removeWhitespace(String s) {
        s = s.replace('\r', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        boolean repeatedSpacesExist = true;
        while (repeatedSpacesExist) {
            int loc = s.indexOf("  ");
            if (loc < 0) {
                repeatedSpacesExist = false;
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(s.substring(0, loc));
            buf.append(" ");
            buf.append(s.substring(loc + 2));
            s = buf.toString();
        }
        return s.trim();
    }

    private void parseComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof GenericComposite) {
            NodeList children = datatypeElement.getChildNodes();
            int compNum = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element nextElement = (Element)children.item(i);
                String localName = nextElement.getLocalName();
                int dotIndex = localName.indexOf(".");
                if (dotIndex > -1) {
                    compNum = Integer.parseInt(localName.substring(dotIndex + 1)) - 1;
                } else {
                    log.debug("Datatype element {} doesn't have a valid numbered name, usgin default index of {}", (Object)datatypeElement.getLocalName(), (Object)compNum);
                }
                Type nextComponent = datatypeObject.getComponent(compNum);
                this.parse(nextComponent, nextElement);
                ++compNum;
            }
        } else {
            Type[] children = datatypeObject.getComponents();
            for (int i = 0; i < children.length; ++i) {
                NodeList matchingElements = datatypeElement.getElementsByTagName(this.makeElementName(datatypeObject, i + 1));
                if (matchingElements.getLength() <= 0) continue;
                this.parse(children[i], (Element)matchingElements.item(0));
            }
        }
    }

    private String makeElementName(Segment s, int child) {
        return s.getName() + "." + child;
    }

    private String makeElementName(Composite composite, int child) {
        return composite.getName() + "." + child;
    }

    private boolean encode(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject instanceof Varies) {
            hasData = this.encodeVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            hasData = this.encodePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            hasData = this.encodeComposite((Composite)datatypeObject, datatypeElement);
        }
        return hasData;
    }

    private boolean encodeVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject.getData() != null) {
            hasData = this.encode(datatypeObject.getData(), datatypeElement);
        }
        return hasData;
    }

    private boolean encodePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasValue = false;
        if (datatypeObject.getValue() != null && !datatypeObject.getValue().equals("")) {
            hasValue = true;
        }
        Text t = datatypeElement.getOwnerDocument().createTextNode(datatypeObject.getValue());
        if (hasValue) {
            try {
                datatypeElement.appendChild(t);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Primitive: ", e);
            }
        }
        return hasValue;
    }

    private boolean encodeComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        Type[] components = datatypeObject.getComponents();
        boolean hasValue = false;
        for (int i = 0; i < components.length; ++i) {
            String name = this.makeElementName(datatypeObject, i + 1);
            Element newNode = datatypeElement.getOwnerDocument().createElement(name);
            boolean componentHasValue = this.encode(components[i], newNode);
            if (!componentHasValue) continue;
            try {
                datatypeElement.appendChild(newNode);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Composite: ", e);
            }
            hasValue = true;
        }
        return hasValue;
    }

    public Segment getCriticalResponseData(String message) throws HL7Exception {
        String version = this.getVersion(message);
        Segment criticalData = Parser.makeControlMSH(version, this.getFactory());
        Terser.set(criticalData, 1, 0, 1, 1, this.parseLeaf(message, "MSH.1", 0));
        Terser.set(criticalData, 2, 0, 1, 1, this.parseLeaf(message, "MSH.2", 0));
        Terser.set(criticalData, 10, 0, 1, 1, this.parseLeaf(message, "MSH.10", 0));
        String procID = this.parseLeaf(message, "MSH.11", 0);
        if (procID == null || procID.length() == 0) {
            procID = this.parseLeaf(message, "PT.1", message.indexOf("MSH.11"));
        }
        Terser.set(criticalData, 11, 0, 1, 1, procID);
        return criticalData;
    }

    public String getAckID(String message) {
        String ackID = null;
        try {
            ackID = this.parseLeaf(message, "msa.2", 0).trim();
        }
        catch (HL7Exception hL7Exception) {
            // empty catch block
        }
        return ackID;
    }

    public String getVersion(String message) throws HL7Exception {
        String version = this.parseLeaf(message, "MSH.12", 0);
        if (version == null || version.trim().length() == 0) {
            version = this.parseLeaf(message, "VID.1", message.indexOf("MSH.12"));
        }
        return version;
    }

    protected String parseLeaf(String message, String tagName, int startAt) throws HL7Exception {
        String value = null;
        int tagStart = message.indexOf("<" + tagName, startAt);
        if (tagStart < 0) {
            tagStart = message.indexOf("<" + tagName.toUpperCase(), startAt);
        }
        int valStart = message.indexOf(">", tagStart) + 1;
        int valEnd = message.indexOf("<", valStart);
        if (tagStart < 0 || valEnd < valStart) {
            throw new HL7Exception("Couldn't find " + tagName + " in message beginning: " + message.substring(0, Math.min(150, message.length())), 101);
        }
        value = message.substring(valStart, valEnd);
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        return value;
    }

    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Message doParseForSpecificPackage(String theMessage, String theVersion, String thePackageName) throws HL7Exception, EncodingNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }
}

