/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.DefaultValidationExceptionHandler;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.Validator;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValidator.class);
    private static final MessageRule[] EMPTY_MESSAGE_RULES_ARRAY = new MessageRule[0];
    private static final EncodingRule[] EMPTY_ENCODING_RULES_ARRAY = new EncodingRule[0];
    private ValidationContext context;

    public DefaultValidator(HapiContext context) {
        ValidationRuleBuilder builder = context.getDefaultValidationRuleBuilder();
        this.context = builder != null ? ValidationContextFactory.fromBuilder(builder) : context.getDefaultValidationContext();
    }

    public DefaultValidator(ValidationContext context) {
        this.context = context;
    }

    public DefaultValidator(ValidationRuleBuilder builder) {
        this(ValidationContextFactory.fromBuilder(builder));
    }

    public boolean validate(Message message) throws HL7Exception {
        return this.validate(message, this.initializeHandler());
    }

    public boolean validate(Message message, ValidationExceptionHandler handler) throws HL7Exception {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        if (handler == null) {
            throw new NullPointerException("ValidationExceptionHandler may not be null");
        }
        Terser t = new Terser(message);
        MessageRule[] rules = EMPTY_MESSAGE_RULES_ARRAY;
        if (this.context != null) {
            rules = this.context.getMessageRules(message.getVersion(), t.get("MSH-9-1"), t.get("MSH-9-2"));
        }
        LOG.debug("Validating message against {} message rules", (Object)rules.length);
        for (MessageRule rule : rules) {
            ValidationException[] ex = rule.test(message);
            if (ex == null || ex.length <= 0) continue;
            handler.onValidationExceptions(ex);
        }
        return handler.validationPassed();
    }

    public boolean validate(String message, boolean isXML, String version) throws HL7Exception {
        return this.validate(message, isXML, version, this.initializeHandler());
    }

    public boolean validate(String message, boolean isXML, String version, ValidationExceptionHandler handler) throws HL7Exception {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        if (handler == null) {
            throw new NullPointerException("ValidationExceptionHandler may not be null");
        }
        EncodingRule[] rules = EMPTY_ENCODING_RULES_ARRAY;
        if (this.context != null) {
            rules = this.context.getEncodingRules(version, isXML ? "XML" : "ER7");
        }
        LOG.debug("Validating message against {} encoding rules", (Object)rules.length);
        for (EncodingRule rule : rules) {
            ValidationException[] ex = rule.test(message);
            if (ex == null || ex.length <= 0) continue;
            handler.onValidationExceptions(ex);
        }
        return handler.validationPassed();
    }

    public ValidationContext getValidationContext() {
        return this.context;
    }

    protected ValidationExceptionHandler initializeHandler() {
        return new DefaultValidationExceptionHandler();
    }
}

