/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.validation.DefaultValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageValidator
extends DefaultValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    private boolean throwOnError = false;

    public MessageValidator(HapiContext context) {
        super(context);
    }

    public MessageValidator(ValidationContext context) {
        this(context, false);
    }

    public MessageValidator(ValidationRuleBuilder builder) {
        super(builder);
    }

    public MessageValidator(ValidationRuleBuilder builder, boolean theFailOnErrorFlag) {
        this(builder);
        this.throwOnError = theFailOnErrorFlag;
    }

    public MessageValidator(ValidationContext theContext, boolean theFailOnErrorFlag) {
        super(theContext);
        this.throwOnError = theFailOnErrorFlag;
    }

    protected ValidationExceptionHandler initializeHandler() {
        return new FirstExceptionThrowingHandler();
    }

    private class FirstExceptionThrowingHandler
    implements ValidationExceptionHandler {
        private ValidationException firstException;

        private FirstExceptionThrowingHandler() {
        }

        public void onValidationExceptions(ValidationException[] exceptions) {
            for (ValidationException ve : exceptions) {
                LOG.error("Invalid message", (Throwable)ve);
                if (this.firstException != null) continue;
                this.firstException = ve;
            }
        }

        public boolean validationPassed() throws HL7Exception {
            if (this.failed() && MessageValidator.this.throwOnError) {
                throw new HL7Exception(this.firstException.getMessage(), this.firstException);
            }
            return !this.failed();
        }

        private boolean failed() {
            return this.firstException != null;
        }
    }
}

