/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuilderSupport
implements Serializable {
    private Predicate predicate;

    protected BuilderSupport() {
    }

    protected Predicate getPredicate() {
        return this.predicate;
    }

    public Predicate isEqual(Object expected) {
        return new EqualsPredicate(expected);
    }

    public Predicate isEqualIgnoreCase(Object expected) {
        return new EqualsPredicate(expected, true);
    }

    public Predicate empty() {
        return new EmptyPredicate();
    }

    public Predicate emptyOr(Predicate predicate) {
        return this.anyOf(this.empty(), predicate);
    }

    public Predicate matches(String regex) {
        return new MatchesPredicate(regex);
    }

    public Predicate startsWith(String prefix) {
        return this.matches("^" + prefix + ".*");
    }

    public Predicate nonNegativeInteger() {
        return this.matches("\\d*");
    }

    public Predicate number() {
        return this.matches("(\\+|\\-)?\\d*\\.?\\d*");
    }

    public Predicate date() {
        return this.matches("(\\d{4}([01]\\d(\\d{2})?)?)?");
    }

    public Predicate time() {
        return this.matches("([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?([\\+\\-]\\d{4})?");
    }

    public Predicate dateTime() {
        return this.matches("(\\d{4}([01]\\d(\\d{2}([012]\\d[0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?");
    }

    public Predicate dateTime25() {
        return this.matches("(\\d{4}([01]\\d(\\d{2}([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?");
    }

    public Predicate usPhoneNumber() {
        return this.matches("(\\d{1,2} )?(\\(\\d{3}\\))?\\d{3}-\\d{4}(X\\d{1,5})?(B\\d{1,5})?(C.*)?");
    }

    public Predicate oid() {
        return this.matches("[0-2](\\.(0|([1-9][0-9]*)))+");
    }

    public Predicate uuid() {
        return this.matches("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}");
    }

    public Predicate matches(String regex, int flags) {
        return new MatchesPredicate(regex, flags);
    }

    public Predicate in(Object ... allowed) {
        return new InPredicate(Arrays.asList(allowed));
    }

    public Predicate in(Collection<?> allowed) {
        return new InPredicate(allowed);
    }

    public Predicate anyOf(Iterable<Predicate> predicates) {
        return new AnyOfPredicate(predicates);
    }

    public Predicate allOf(Iterable<Predicate> predicates) {
        return new AllOfPredicate(predicates);
    }

    public Predicate anyOf(Predicate ... predicates) {
        return this.anyOf(Arrays.asList(predicates));
    }

    public Predicate allOf(Predicate ... predicates) {
        return this.allOf(Arrays.asList(predicates));
    }

    public Predicate not(Predicate delegate) {
        return new NotPredicate(delegate);
    }

    public Predicate maxLength(int maxSize) {
        return new MaxLengthPredicate(maxSize);
    }

    public Predicate withdrawn() {
        return new WithdrawnPredicate();
    }

    public Predicate always(boolean b) {
        return new AlwaysPredicate(b);
    }

    public Predicate alwaysFails() {
        return this.always(false);
    }

    private static String join(Iterable<?> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllOfPredicate
    implements Predicate {
        private Iterable<Predicate> predicates;

        public AllOfPredicate(Iterable<Predicate> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean evaluate(Object data) throws ValidationException {
            for (Predicate p : this.predicates) {
                if (p.evaluate(data)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            String and = " and ";
            StringBuffer b = new StringBuffer();
            for (Predicate p : this.predicates) {
                b.append(p.getDescription()).append(and);
            }
            return b.substring(0, b.length() - and.length());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnyOfPredicate
    implements Predicate {
        private Iterable<Predicate> predicates;

        public AnyOfPredicate(Iterable<Predicate> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean evaluate(Object data) throws ValidationException {
            for (Predicate p : this.predicates) {
                if (!p.evaluate(data)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            String or = " or ";
            StringBuffer b = new StringBuffer();
            for (Predicate p : this.predicates) {
                b.append(p.getDescription()).append(or);
            }
            return b.substring(0, b.length() - or.length());
        }
    }

    private class MatchesPredicate
    implements Predicate {
        private Pattern p;

        public MatchesPredicate(String regex) {
            this.p = Pattern.compile(regex);
        }

        public MatchesPredicate(String regex, int flags) {
            this.p = Pattern.compile(regex, flags);
        }

        public boolean evaluate(Object data) throws ValidationException {
            return data != null && this.p.matcher(data.toString()).matches();
        }

        public String getDescription() {
            return "matching with " + String.valueOf(this.p.pattern());
        }
    }

    private class EmptyPredicate
    implements Predicate {
        public boolean evaluate(Object data) throws ValidationException {
            return data == null || "".equals(data) || "\"\"".equals(data);
        }

        public String getDescription() {
            return "empty";
        }
    }

    private class EqualsPredicate
    implements Predicate {
        private Object expected;
        private boolean ignoresCase;

        public EqualsPredicate(Object expected) {
            this(expected, false);
        }

        EqualsPredicate(Object expected, boolean ignoresCase) {
            this.expected = expected;
            this.ignoresCase = ignoresCase;
        }

        public boolean evaluate(Object data) throws ValidationException {
            if (this.ignoresCase) {
                return data == null && this.expected == null || data != null && data.toString().equalsIgnoreCase(this.expected.toString());
            }
            return data == null && this.expected == null || data != null && data.equals(this.expected);
        }

        public String getDescription() {
            return "equal to " + String.valueOf(this.expected);
        }
    }

    private class NotPredicate
    implements Predicate {
        private Predicate delegate;

        public NotPredicate(Predicate delegate) {
            this.delegate = delegate;
        }

        public boolean evaluate(Object data) throws ValidationException {
            try {
                return !this.delegate.evaluate(data);
            }
            catch (ValidationException e) {
                return true;
            }
        }

        public String getDescription() {
            return "not " + this.delegate.getDescription();
        }
    }

    private class WithdrawnPredicate
    extends MaxLengthPredicate {
        public WithdrawnPredicate() {
            super(0);
        }

        public String getDescription() {
            return "empty because it is withdrawn from the current HL7 version and should not be used";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InPredicate
    implements Predicate {
        private Collection<?> allowed;

        InPredicate(Collection<?> allowed) {
            this.allowed = allowed;
        }

        @Override
        public boolean evaluate(Object data) throws ValidationException {
            return this.allowed.contains(data);
        }

        @Override
        public String getDescription() {
            return "in [" + BuilderSupport.join(this.allowed, ",") + "]";
        }
    }

    private class MaxLengthPredicate
    implements Predicate {
        private int maxLength = Integer.MAX_VALUE;

        public MaxLengthPredicate(int maxSize) {
            this.maxLength = maxSize;
        }

        public boolean evaluate(Object data) throws ValidationException {
            return data == null || data.toString().length() <= this.maxLength;
        }

        public String getDescription() {
            return "shorter than " + this.maxLength + " characters";
        }
    }

    private class AlwaysPredicate
    implements Predicate {
        private boolean b;

        AlwaysPredicate(boolean b) {
            this.b = b;
        }

        public boolean evaluate(Object data) throws ValidationException {
            return this.b;
        }

        public String getDescription() {
            return this.b ? "anything" : "nothing";
        }
    }
}

