/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.impl.EncodingRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import ca.uhn.hl7v2.validation.impl.XMLSchemaRule;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingRuleBuilder
extends RuleTypeBuilder<EncodingRule> {
    private String encoding;

    protected EncodingRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, String encoding) {
        super(rules, versions);
        this.encoding = encoding;
    }

    public EncodingRuleBuilder xsd() {
        return this.test(new XMLSchemaRule());
    }

    public EncodingRuleBuilder test(EncodingRule rule) {
        this.addRuleBindings(rule);
        return this;
    }

    public EncodingRuleBuilder description(String description) {
        this.description = description;
        return this;
    }

    public EncodingRuleBuilder refersToSection(String sectionReference) {
        this.sectionReference = sectionReference;
        return this;
    }

    String getEncoding() {
        return this.encoding;
    }

    @Override
    protected Collection<RuleBinding<EncodingRule>> getRuleBindings(EncodingRule rule, String version) {
        EncodingRuleBinding binding = new EncodingRuleBinding(version, this.encoding, rule);
        return Collections.singletonList(binding);
    }
}

