/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.util.ReadOnlyMessageIterator;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicateMessageRule;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.builder.TerserExpression;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import ca.uhn.hl7v2.validation.impl.ConformanceProfileRule;
import ca.uhn.hl7v2.validation.impl.MessageRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRuleBuilder
extends RuleTypeBuilder<MessageRule> {
    private String messageType;
    private String triggerEvent;
    private static final MessageRule ONLY_KNOWN_SEGMENTS = new OnlyKnownSegmentsRule();

    protected MessageRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, String messageType, String triggerEvent) {
        super(rules, versions);
        this.messageType = messageType;
        this.triggerEvent = triggerEvent;
    }

    public MessageRuleBuilder terser(String spec, Predicate predicate) {
        return this.test(new TerserMessageRule(spec, predicate));
    }

    public MessageRuleBuilder onlyKnownSegments() {
        return this.test(ONLY_KNOWN_SEGMENTS);
    }

    public MessageRuleBuilder conformance() {
        return this.conformance(null);
    }

    public MessageRuleBuilder conformance(String profileId) {
        return this.description("Unknown segments found in message").test(new ConformanceProfileRule(profileId));
    }

    public MessageRuleBuilder test(MessageRule rule) {
        this.addRuleBindings(rule);
        return this;
    }

    public MessageRuleBuilder description(String description) {
        this.description = description;
        return this;
    }

    public MessageRuleBuilder refersToSection(String sectionReference) {
        this.sectionReference = sectionReference;
        return this;
    }

    String getMessageType() {
        return this.messageType;
    }

    String getTriggerEvent() {
        return this.triggerEvent;
    }

    @Override
    protected Collection<RuleBinding<MessageRule>> getRuleBindings(MessageRule rule, String version) {
        MessageRuleBinding binding = new MessageRuleBinding(version, this.messageType, this.triggerEvent, rule);
        return Collections.singletonList(binding);
    }

    private static class OnlyKnownSegmentsRule
    extends AbstractMessageRule {
        private OnlyKnownSegmentsRule() {
        }

        public ValidationException[] apply(Message msg) {
            ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
            Iterator<Structure> iter = ReadOnlyMessageIterator.createPopulatedStructureIterator(msg, GenericSegment.class);
            while (iter.hasNext()) {
                exceptions.add(new ValidationException("Found unknown segment: " + iter.next().getName()));
            }
            return exceptions.toArray(new ValidationException[exceptions.size()]);
        }
    }

    private class TerserMessageRule
    extends PredicateMessageRule {
        TerserMessageRule(String terserExpression, Predicate predicate) {
            super(predicate, new TerserExpression(terserExpression));
        }
    }
}

