/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Expression;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicateRuleSupport;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PredicateMessageRule
extends AbstractMessageRule
implements PredicateRuleSupport<Message> {
    private Predicate testPredicate;
    private Expression<Message> testExpression;

    PredicateMessageRule(Predicate predicate, Expression<Message> expression) {
        this.testPredicate = predicate;
        this.testExpression = expression;
    }

    @Override
    public ValidationException[] apply(Message msg) {
        try {
            Object subject = this.testExpression.evaluate(msg);
            return this.result(this.getPredicate().evaluate(subject), subject);
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Predicate getPredicate() {
        return this.testPredicate;
    }

    @Override
    public String getDescription() {
        return this.testExpression.getDescription() + " '%s' requires to be " + this.testPredicate.getDescription();
    }
}

