/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicateRuleSupport;
import ca.uhn.hl7v2.validation.impl.AbstractPrimitiveTypeRule;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatePrimitiveTypeRule
extends AbstractPrimitiveTypeRule
implements PredicateRuleSupport<String> {
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^\\s+");
    private Predicate predicate;
    private boolean trimLeadingWhitespace;

    public PredicatePrimitiveTypeRule(Predicate predicate) {
        this(predicate, false);
    }

    public PredicatePrimitiveTypeRule(Predicate predicate, boolean trimLeadingWhitespace) {
        this.predicate = predicate;
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public String getDescription() {
        return "Primitive value '%s' requires to be " + this.predicate.getDescription();
    }

    @Override
    public String correct(String value) {
        return this.trimLeadingWhitespace && value != null ? LEADING_WHITESPACE.matcher(value).replaceAll("") : value;
    }

    @Override
    public boolean test(String value) {
        try {
            return this.getPredicate().evaluate(value);
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public ValidationException[] apply(String value) {
        try {
            return this.result(this.getPredicate().evaluate(this.correct(value)), value);
        }
        catch (ValidationException e) {
            return this.failed(e);
        }
    }

    public String toString() {
        return this.getDescription();
    }
}

