/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicatePrimitiveTypeRule;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.impl.PrimitiveTypeRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveRuleBuilder
extends RuleTypeBuilder<PrimitiveTypeRule> {
    private Set<String> types;

    protected PrimitiveRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, Set<String> types) {
        super(rules, versions);
        this.types = types;
    }

    public PrimitiveRuleBuilder is(Predicate predicate) {
        return this.test(new PredicatePrimitiveTypeRule(predicate));
    }

    public PrimitiveRuleBuilder trimmed(Predicate predicate) {
        return this.test(new PredicatePrimitiveTypeRule(predicate, true));
    }

    public PrimitiveRuleBuilder trimmed() {
        return this.trimmed(this.always(true));
    }

    public PrimitiveRuleBuilder test(PrimitiveTypeRule rule) {
        this.addRuleBindings(rule);
        return this;
    }

    public PrimitiveRuleBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PrimitiveRuleBuilder refersToSection(String sectionReference) {
        this.sectionReference = sectionReference;
        return this;
    }

    @Override
    protected Collection<RuleBinding<PrimitiveTypeRule>> getRuleBindings(PrimitiveTypeRule rule, String version) {
        ArrayList<RuleBinding<PrimitiveTypeRule>> bindings = new ArrayList<RuleBinding<PrimitiveTypeRule>>();
        for (String type : this.types) {
            bindings.add(new PrimitiveTypeRuleBinding(version, type, rule));
        }
        return bindings;
    }

    Set<String> getTypes() {
        return this.types;
    }
}

