/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.EncodingRuleBuilder;
import ca.uhn.hl7v2.validation.builder.MessageRuleBuilder;
import ca.uhn.hl7v2.validation.builder.PrimitiveRuleBuilder;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTypeBuilder<T extends Rule<?>>
extends ValidationRuleBuilder {
    protected Set<Version> versions;
    protected String description;
    protected String sectionReference;

    protected RuleTypeBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions) {
        super(rules);
        if (versions.size() == 0) {
            throw new IllegalArgumentException("Must specify a version");
        }
        this.versions = versions;
    }

    protected RuleTypeBuilder(List<RuleBinding<? extends Rule<?>>> rules, Version ... versions) {
        super(rules);
        if (versions.length == 0) {
            throw new IllegalArgumentException("Must specify a version");
        }
        this.versions = new HashSet<Version>(Arrays.asList(versions));
    }

    public PrimitiveRuleBuilder primitive(String ... type) {
        if (type.length == 0) {
            throw new IllegalArgumentException("Must specify a type");
        }
        return new PrimitiveRuleBuilder(this.rules, this.versions, new HashSet<String>(Arrays.asList(type)));
    }

    public MessageRuleBuilder message(String eventType, String triggerEvent) {
        return new MessageRuleBuilder(this.rules, this.versions, eventType, triggerEvent);
    }

    public EncodingRuleBuilder encoding(String encoding) {
        return new EncodingRuleBuilder(this.rules, this.versions, encoding);
    }

    protected void addRuleBindings(T rule) {
        for (Version version : this.versions) {
            this.rules.addAll(this.getRuleBindings(rule, version.getVersion()));
        }
    }

    protected Collection<RuleBinding<T>> getRuleBindings(T rule, String version) {
        return Collections.EMPTY_LIST;
    }
}

