/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.BuilderSupport;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleBuilder
extends BuilderSupport {
    protected List<RuleBinding<? extends Rule<?>>> rules = new ArrayList();

    public ValidationRuleBuilder() {
    }

    protected ValidationRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules) {
        this.rules = rules;
    }

    public final void initialize() {
        if (this.rules.isEmpty()) {
            this.configure();
        }
    }

    protected void configure() {
    }

    public List<RuleBinding<? extends Rule<?>>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public <T extends Rule<?>> RuleTypeBuilder<T> forVersion(Version ... version) {
        return new RuleTypeBuilder(this.rules, version);
    }

    public <T extends Rule<?>> RuleTypeBuilder<T> forVersion(String ... version) {
        Version[] versions = new Version[version.length];
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = Version.versionOf(version[i]);
        }
        return new RuleTypeBuilder(this.rules, versions);
    }

    public VersionExpressionBuilder forVersion() {
        return new VersionExpressionBuilder();
    }

    public <T extends Rule<?>> RuleTypeBuilder<T> forAllVersions() {
        return new RuleTypeBuilder(this.rules, Version.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VersionExpressionBuilder {
        public <T extends Rule<?>> RuleTypeBuilder<T> asOf(String version) {
            return this.asOf(Version.versionOf(version));
        }

        public <T extends Rule<?>> RuleTypeBuilder<T> asOf(Version version) {
            return new RuleTypeBuilder(ValidationRuleBuilder.this.rules, Version.asOf(version));
        }

        public <T extends Rule<?>> RuleTypeBuilder<T> before(String version) {
            return this.before(Version.versionOf(version));
        }

        public <T extends Rule<?>> RuleTypeBuilder<T> before(Version version) {
            return new RuleTypeBuilder(ValidationRuleBuilder.this.rules, Version.before(version));
        }

        public <T extends Rule<?>> RuleTypeBuilder<T> except(String version) {
            return this.except(Version.versionOf(version));
        }

        public <T extends Rule<?>> RuleTypeBuilder<T> except(Version version) {
            return new RuleTypeBuilder(ValidationRuleBuilder.this.rules, Version.except(version));
        }
    }
}

