/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleSupport<T>
implements Rule<T> {
    private static final ValidationException[] PASSED = new ValidationException[0];

    protected ValidationException[] result(boolean result, Object value) {
        return result ? this.passed() : this.failedWithValue(value);
    }

    protected ValidationException[] passed() {
        return PASSED;
    }

    protected ValidationException[] failedWithValue(Object value) {
        String description = this.getDescription();
        String msg = String.format(description, String.valueOf(value));
        return this.failed("Validation failed: " + msg);
    }

    protected ValidationException[] failed(String msg) {
        return new ValidationException[]{new ValidationException(msg)};
    }

    protected ValidationException[] failed(Exception e) {
        if (e instanceof ValidationException) {
            return new ValidationException[]{(ValidationException)e};
        }
        return new ValidationException[]{new ValidationException("Validation failed: " + e.getMessage(), e)};
    }

    @Override
    public String getSectionReference() {
        return null;
    }
}

