/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.builder.support.DefaultValidationBuilder;
import ca.uhn.hl7v2.validation.builder.support.NoValidationBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextImpl;

public class ValidationContextFactory {
    private static ValidationContext ourContext;
    public static final String CONTEXT_PROPERTY = "ca.uhn.hl7v2.validation.context_class";

    public static synchronized ValidationContext getContext() throws ValidationException {
        if (ourContext == null) {
            String contextClassName = System.getProperty(CONTEXT_PROPERTY);
            ourContext = contextClassName == null ? ValidationContextFactory.defaultValidation() : ValidationContextFactory.customValidation(contextClassName);
        }
        return ourContext;
    }

    public static ValidationContext noValidation() {
        return new ValidationContextImpl(new NoValidationBuilder());
    }

    public static ValidationContext defaultValidation() {
        return new ValidationContextImpl(new DefaultValidationBuilder());
    }

    public static ValidationRuleBuilder customBuilder(String ruleBuilderClassName) throws ValidationException {
        try {
            Class<?> c = Class.forName(ruleBuilderClassName);
            return (ValidationRuleBuilder)c.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    public static ValidationContext fromBuilder(String ruleBuilderClassName) throws ValidationException {
        return new ValidationContextImpl(ValidationContextFactory.customBuilder(ruleBuilderClassName));
    }

    public static ValidationContext fromBuilder(ValidationRuleBuilder builder) {
        return new ValidationContextImpl(builder);
    }

    public static ValidationContext customValidation(String contextClassName) throws ValidationException {
        try {
            Class<?> c = Class.forName(contextClassName);
            return (ValidationContext)c.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }
}

