/*
Copyright 2015 Alexander Bunkenburg <alex@inspiracio.cat>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cat.inspiracio.html;

import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;

import cat.inspiracio.dom.InitialDOMImplementation;

/** Builds html5 documents.
 * Public visibility so that it can be extended. */
public class HTMLDOMImplementation 
	extends InitialDOMImplementation 
	implements org.w3c.dom.html.HTMLDOMImplementation	//maybe don't need this
{

	/** protected so that outside of this package, only subclasses can instantiate. */
	protected HTMLDOMImplementation(){super();}
	
	/** Called for newDocument() */
	@Override public HTMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype)throws DOMException{
		String title=null;
		return createHTMLDocument(title);
	}
	
    /**
     * Creates an <code>HTMLDocument</code> object with the minimal tree made
     * of the following elements: 
     * <code>html</code> , 
     * <code>head</code> ,
     * <code>title</code> , and 
     * <code>body</code> .
     * 
     * @param title  The title of the document to be set as the content of the
     *   <code>title</code> element, through a child <code>Text</code> node.
     * 
     * @return  A new <code>HTMLDocument</code> object.
     */
	@Override public HTMLDocument createHTMLDocument(String title) {
		HTMLDocumentImp d=new HTMLDocumentImp();
		if(title!=null)
			d.setTitle(title);
		return d;
	}

}
